/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.core.pipeline.server.SslUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class HttpServerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerProvider.class);
    private final DataPrepperConfiguration dataPrepperConfiguration;

    @Inject
    public HttpServerProvider(DataPrepperConfiguration dataPrepperConfiguration) {
        this.dataPrepperConfiguration = dataPrepperConfiguration;
    }

    public HttpServer get() {
        InetSocketAddress socketAddress = new InetSocketAddress(this.dataPrepperConfiguration.getServerPort());
        try {
            if (this.dataPrepperConfiguration.ssl()) {
                LOG.info("Creating Data Prepper server with TLS");
                SSLContext sslContext = SslUtil.createSslContext(this.dataPrepperConfiguration.getKeyStoreFilePath(), this.dataPrepperConfiguration.getKeyStorePassword(), this.dataPrepperConfiguration.getPrivateKeyPassword());
                HttpsServer server = HttpsServer.create(socketAddress, 0);
                server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    @Override
                    public void configure(HttpsParameters params) {
                        SSLContext context = this.getSSLContext();
                        SSLParameters sslParams = context.getDefaultSSLParameters();
                        params.setSSLParameters(sslParams);
                    }
                });
                return server;
            }
            LOG.warn("Creating Data Prepper server without TLS. This is not secure.");
            LOG.warn("In order to set up TLS for the Data Prepper server, go here: https://github.com/opensearch-project/data-prepper/blob/main/docs/configuration.md#server-configuration");
            return HttpServer.create(socketAddress, 0);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create server", ex);
        }
    }
}

