/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.core.pipeline.server.GetPipelinesHandler;
import org.opensearch.dataprepper.core.pipeline.server.HttpServerProvider;
import org.opensearch.dataprepper.core.pipeline.server.ListPipelinesHandler;
import org.opensearch.dataprepper.core.pipeline.server.PrometheusMetricsHandler;
import org.opensearch.dataprepper.core.pipeline.server.ShutdownHandler;
import org.opensearch.dataprepper.plugins.encryption.EncryptionHttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class DataPrepperServer {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepperServer.class);
    private final HttpServerProvider serverProvider;
    private final ListPipelinesHandler listPipelinesHandler;
    private final GetPipelinesHandler getPipelinesHandler;
    private final ShutdownHandler shutdownHandler;
    private final EncryptionHttpHandler encryptionHttpHandler;
    private final PrometheusMeterRegistry prometheusMeterRegistry;
    private final Authenticator authenticator;
    private final ExecutorService executorService;
    private HttpServer server;

    @Inject
    public DataPrepperServer(HttpServerProvider serverProvider, ListPipelinesHandler listPipelinesHandler, ShutdownHandler shutdownHandler, GetPipelinesHandler getPipelinesHandler, @Autowired(required=false) @Nullable EncryptionHttpHandler encryptionHttpHandler, @Autowired(required=false) @Nullable PrometheusMeterRegistry prometheusMeterRegistry, @Autowired(required=false) @Nullable Authenticator authenticator) {
        this.serverProvider = serverProvider;
        this.listPipelinesHandler = listPipelinesHandler;
        this.shutdownHandler = shutdownHandler;
        this.getPipelinesHandler = getPipelinesHandler;
        this.encryptionHttpHandler = encryptionHttpHandler;
        this.prometheusMeterRegistry = prometheusMeterRegistry;
        this.authenticator = authenticator;
        this.executorService = Executors.newFixedThreadPool(3);
    }

    public void start() {
        this.server = this.createServer();
        this.server.setExecutor(this.executorService);
        this.server.start();
        LOG.info("Data Prepper server running at :{}", (Object)this.server.getAddress().getPort());
    }

    private HttpServer createServer() {
        HttpServer server = this.serverProvider.get();
        this.createContext(server, this.listPipelinesHandler, this.authenticator, "/list");
        this.createContext(server, this.shutdownHandler, this.authenticator, "/shutdown");
        this.createContext(server, this.getPipelinesHandler, this.authenticator, "/pipelines");
        if (this.encryptionHttpHandler != null) {
            this.createContext(server, (HttpHandler)this.encryptionHttpHandler, this.authenticator, "/encryption/rotate");
        }
        if (this.prometheusMeterRegistry != null) {
            PrometheusMetricsHandler prometheusMetricsHandler = new PrometheusMetricsHandler(this.prometheusMeterRegistry);
            this.createContext(server, prometheusMetricsHandler, this.authenticator, "/metrics/prometheus", "/metrics/sys");
        }
        return server;
    }

    private void createContext(HttpServer httpServer, HttpHandler httpHandler, @Nullable Authenticator authenticator, String ... paths) {
        for (String path : paths) {
            HttpContext context = httpServer.createContext(path, httpHandler);
            if (authenticator == null) continue;
            context.setAuthenticator(authenticator);
        }
    }

    public void stop() {
        this.server.stop(0);
        this.executorService.shutdownNow();
        LOG.info("Data Prepper server stopped");
    }
}

