/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import io.micrometer.cloudwatch2.CloudWatchConfig;
import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;

public class CloudWatchMeterRegistryProvider {
    private static final String CLOUDWATCH_PROPERTIES = "cloudwatch.properties";
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchMeterRegistryProvider.class);
    private final CloudWatchMeterRegistry cloudWatchMeterRegistry;

    public CloudWatchMeterRegistryProvider() {
        this(CLOUDWATCH_PROPERTIES, CloudWatchAsyncClient.create());
    }

    public CloudWatchMeterRegistryProvider(String cloudWatchPropertiesFilePath, CloudWatchAsyncClient cloudWatchAsyncClient) {
        CloudWatchConfig cloudWatchConfig = this.createCloudWatchConfig(Objects.requireNonNull(cloudWatchPropertiesFilePath, "cloudWatchPropertiesFilePath must not be null"));
        this.cloudWatchMeterRegistry = new CloudWatchMeterRegistry(cloudWatchConfig, Clock.SYSTEM, Objects.requireNonNull(cloudWatchAsyncClient, "cloudWatchAsyncClient must not be null"));
    }

    public CloudWatchMeterRegistry getCloudWatchMeterRegistry() {
        return this.cloudWatchMeterRegistry;
    }

    private CloudWatchConfig createCloudWatchConfig(String cloudWatchPropertiesFilePath) {
        CloudWatchConfig cloudWatchConfig;
        block8: {
            InputStream inputStream = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(cloudWatchPropertiesFilePath));
            try {
                Properties cloudwatchProperties = new Properties();
                cloudwatchProperties.load(inputStream);
                cloudWatchConfig = cloudwatchProperties::getProperty;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.error("Encountered exception in creating CloudWatchConfig for CloudWatchMeterRegistry, Proceeding without metrics", (Throwable)ex);
                    return null;
                }
            }
            inputStream.close();
        }
        return cloudWatchConfig;
    }
}

