/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.server;

import com.linecorp.armeria.server.Server;
import java.util.concurrent.ExecutionException;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePeerForwarderServer
implements PeerForwarderServer {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePeerForwarderServer.class);
    private final PeerForwarderConfiguration peerForwarderConfiguration;
    private final Server sever;

    public RemotePeerForwarderServer(PeerForwarderConfiguration peerForwarderConfiguration, Server server) {
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.sever = server;
    }

    @Override
    public void start() {
        try {
            this.sever.start().get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        LOG.info("Peer Forwarder server started on port: {}", (Object)this.peerForwarderConfiguration.getServerPort());
    }

    @Override
    public void stop() {
        if (this.sever != null) {
            try {
                this.sever.stop().get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        LOG.info("Peer Forwarder Server stopped.");
    }
}

