/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.discovery;

import com.google.common.base.Preconditions;
import com.linecorp.armeria.client.Endpoint;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.discovery.DiscoveryUtils;
import org.opensearch.dataprepper.core.peerforwarder.discovery.PeerListProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticPeerListProvider
implements PeerListProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticPeerListProvider.class);
    public static final String LOCAL_ENDPOINT = "127.0.0.1";
    private final List<String> endpoints;

    public StaticPeerListProvider(List<String> dataPrepperEndpoints, PluginMetrics pluginMetrics) {
        if (dataPrepperEndpoints == null || dataPrepperEndpoints.isEmpty()) {
            throw new RuntimeException("Peer endpoints list cannot be empty");
        }
        this.endpoints = Collections.unmodifiableList(dataPrepperEndpoints);
        LOG.info("Found endpoints: {}", this.endpoints);
        pluginMetrics.gauge("peerEndpoints", this.endpoints, List::size);
    }

    static StaticPeerListProvider createPeerListProvider(PeerForwarderConfiguration peerForwarderConfiguration, PluginMetrics pluginMetrics) {
        List<String> endpoints = peerForwarderConfiguration.getStaticEndpoints();
        Objects.requireNonNull(endpoints, "Missing static_endpoints configuration value");
        List invalidEndpoints = endpoints.stream().filter(endpoint -> !DiscoveryUtils.validateEndpoint(endpoint)).collect(Collectors.toList());
        Preconditions.checkState((boolean)invalidEndpoints.isEmpty(), (String)"Including invalid endpoints: %s", invalidEndpoints);
        return new StaticPeerListProvider(endpoints, pluginMetrics);
    }

    @Override
    public List<String> getPeerList() {
        return this.endpoints;
    }

    public void addListener(Consumer<? super List<Endpoint>> listener) {
    }

    public void removeListener(Consumer<?> listener) {
    }
}

