/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.discovery;

import com.google.common.base.Preconditions;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.discovery.DiscoveryUtils;
import org.opensearch.dataprepper.core.peerforwarder.discovery.PeerListProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsPeerListProvider
implements PeerListProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DnsPeerListProvider.class);
    private static final int MIN_TTL = 10;
    private static final int MAX_TTL = 20;
    private final DnsAddressEndpointGroup endpointGroup;

    public DnsPeerListProvider(DnsAddressEndpointGroup endpointGroup, PluginMetrics pluginMetrics) {
        Objects.requireNonNull(endpointGroup);
        this.endpointGroup = endpointGroup;
        try {
            endpointGroup.whenReady().get();
            LOG.info("Found endpoints: {}", (Object)String.join((CharSequence)",", endpointGroup.endpoints().toString()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Caught exception while querying DNS", e);
        }
        pluginMetrics.gauge("peerEndpoints", (Object)endpointGroup, group -> group.endpoints().size());
    }

    static DnsPeerListProvider createPeerListProvider(PeerForwarderConfiguration peerForwarderConfiguration, PluginMetrics pluginMetrics) {
        String domainName = peerForwarderConfiguration.getDomainName();
        Objects.requireNonNull(domainName, "Missing domain_name configuration value");
        Preconditions.checkState((boolean)DiscoveryUtils.validateEndpoint(domainName), (String)"Invalid domain name: %s", (Object)domainName);
        DnsAddressEndpointGroup endpointGroup = ((DnsAddressEndpointGroupBuilder)DnsAddressEndpointGroup.builder((String)domainName).ttl(10, 20)).build();
        return new DnsPeerListProvider(endpointGroup, pluginMetrics);
    }

    @Override
    public List<String> getPeerList() {
        return this.endpointGroup.endpoints().stream().map(Endpoint::ipAddr).collect(Collectors.toList());
    }

    public void addListener(Consumer<? super List<Endpoint>> listener) {
        this.endpointGroup.addListener(listener);
    }

    public void removeListener(Consumer<?> listener) {
        this.endpointGroup.removeListener(listener);
    }
}

