/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.discovery;

import java.util.Objects;
import java.util.function.BiFunction;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.discovery.AwsCloudMapPeerListProvider;
import org.opensearch.dataprepper.core.peerforwarder.discovery.DnsPeerListProvider;
import org.opensearch.dataprepper.core.peerforwarder.discovery.LocalPeerListProvider;
import org.opensearch.dataprepper.core.peerforwarder.discovery.PeerListProvider;
import org.opensearch.dataprepper.core.peerforwarder.discovery.StaticPeerListProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public enum DiscoveryMode {
    STATIC(StaticPeerListProvider::createPeerListProvider),
    DNS(DnsPeerListProvider::createPeerListProvider),
    AWS_CLOUD_MAP(AwsCloudMapPeerListProvider::createPeerListProvider),
    LOCAL_NODE(LocalPeerListProvider::createPeerListProvider);

    private final BiFunction<PeerForwarderConfiguration, PluginMetrics, PeerListProvider> creationFunction;

    private DiscoveryMode(BiFunction<PeerForwarderConfiguration, PluginMetrics, PeerListProvider> creationFunction) {
        Objects.requireNonNull(creationFunction);
        this.creationFunction = creationFunction;
    }

    public PeerListProvider create(PeerForwarderConfiguration peerForwarderConfiguration, PluginMetrics pluginMetrics) {
        return this.creationFunction.apply(peerForwarderConfiguration, pluginMetrics);
    }
}

