/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.config;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.DataPrepper;
import org.opensearch.dataprepper.core.parser.config.MetricTagFilter;
import org.springframework.util.AntPathMatcher;

public class CustomTagsMeterFilter
implements MeterFilter {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher(".");
    private final List<MetricTagFilter> metricTagFilters;
    private final Map<String, String> metricTagsWithServiceName;

    public CustomTagsMeterFilter(Map<String, String> metricTags, List<MetricTagFilter> metricTagFilters) {
        this.metricTagFilters = metricTagFilters;
        this.metricTagsWithServiceName = new HashMap<String, String>(metricTags);
        this.metricTagsWithServiceName.putIfAbsent("serviceName", DataPrepper.getServiceNameForMetrics());
    }

    public Meter.Id map(Meter.Id id) {
        for (MetricTagFilter metricTagFilter : this.metricTagFilters) {
            String metricRegex = metricTagFilter.getPattern();
            if (!ANT_PATH_MATCHER.match(metricRegex, id.getName())) continue;
            Set<Map.Entry<String, String>> metricFilterTags = metricTagFilter.getTags().entrySet();
            List tagList = metricFilterTags.stream().map((? super T tag) -> Tag.of((String)((String)tag.getKey()), (String)((String)tag.getValue()))).collect(Collectors.toList());
            return MeterFilter.commonTags(tagList).map(id);
        }
        return MeterFilter.commonTags((Iterable)this.metricTagsWithServiceName.entrySet().stream().map((? super T e) -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList())).map(id);
    }
}

