/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.buffer.DelegatingBuffer;
import org.opensearch.dataprepper.model.record.Record;

class MultiBufferDecorator<T extends Record<?>>
extends DelegatingBuffer<T>
implements Buffer<T> {
    private final List<Buffer> allBuffers;

    MultiBufferDecorator(Buffer primaryBuffer, List<Buffer> secondaryBuffers) {
        super(primaryBuffer);
        this.allBuffers = new ArrayList<Buffer>(1 + secondaryBuffers.size());
        this.allBuffers.add(primaryBuffer);
        this.allBuffers.addAll(secondaryBuffers);
    }

    public boolean isEmpty() {
        return this.allBuffers.stream().allMatch(Buffer::isEmpty);
    }

    public Duration getDrainTimeout() {
        return this.allBuffers.stream().map(Buffer::getDrainTimeout).reduce(Duration.ZERO, Duration::plus);
    }

    public Optional<Integer> getMaxRequestSize() {
        OptionalInt maxRequestSize = this.allBuffers.stream().filter(b -> b.getMaxRequestSize().isPresent()).mapToInt(b -> (Integer)b.getMaxRequestSize().get()).min();
        return maxRequestSize.isPresent() ? Optional.of(maxRequestSize.getAsInt()) : Optional.empty();
    }

    public Optional<Integer> getOptimalRequestSize() {
        OptionalInt optimalRequestSize = this.allBuffers.stream().filter(b -> b.getOptimalRequestSize().isPresent()).mapToInt(b -> (Integer)b.getOptimalRequestSize().get()).min();
        return optimalRequestSize.isPresent() ? Optional.of(optimalRequestSize.getAsInt()) : Optional.empty();
    }

    public void shutdown() {
        this.allBuffers.forEach(Buffer::shutdown);
    }
}

