/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.meter;

import io.micrometer.cloudwatch2.CloudWatchNamingConvention;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.opensearch.dataprepper.core.meter.EMFLoggingRegistryConfig;
import org.opensearch.dataprepper.core.meter.EMFMetricUtils;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.environment.EnvironmentProvider;
import software.amazon.cloudwatchlogs.emf.logger.MetricsLogger;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.Unit;

public class EMFLoggingMeterRegistry
extends StepMeterRegistry {
    private static final String NAMESPACE = "DataPrepper";
    private static final Map<String, Unit> UNIT_BY_LOWERCASE_VALUE;
    private final EMFLoggingRegistryConfig config;
    private final Environment environment;
    private static final WarnThenDebugLogger warnThenDebugLogger;

    public EMFLoggingMeterRegistry(EMFLoggingRegistryConfig config) {
        this(config, (Environment)new EnvironmentProvider().resolveEnvironment().join(), Clock.SYSTEM);
    }

    public EMFLoggingMeterRegistry(EMFLoggingRegistryConfig config, Environment environment, Clock clock) {
        this(config, environment, clock, (ThreadFactory)new NamedThreadFactory("emf-logging-metrics-publisher"));
    }

    EMFLoggingMeterRegistry(EMFLoggingRegistryConfig config, Environment environment, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.environment = environment;
        this.config().namingConvention((NamingConvention)new CloudWatchNamingConvention());
        this.start(threadFactory);
    }

    protected void publish() {
        if (this.config.enabled()) {
            this.metricsLoggers().forEach(MetricsLogger::flush);
        }
    }

    List<MetricsLogger> metricsLoggers() {
        Snapshot snapshot = new Snapshot();
        Map<List, List<Meter>> tagsToMeters = this.getMeters().stream().collect(Collectors.groupingBy(meter -> meter.getId().getConventionTags(this.config().namingConvention())));
        return tagsToMeters.entrySet().stream().map(entry -> {
            List tags = (List)entry.getKey();
            MetricsLogger metricsLogger = this.prepareMetricsLogger(tags, snapshot.timestamp);
            List meters = (List)entry.getValue();
            meters.stream().flatMap(m -> (Stream)m.match(snapshot::gaugeData, snapshot::counterData, snapshot::timerData, snapshot::summaryData, snapshot::longTaskTimerData, snapshot::timeGaugeData, snapshot::functionCounterData, snapshot::functionTimerData, snapshot::metricData)).forEach(metricDataPoint -> metricsLogger.putMetric(metricDataPoint.key, metricDataPoint.value, metricDataPoint.unit));
            return metricsLogger;
        }).collect(Collectors.toList());
    }

    private MetricsLogger prepareMetricsLogger(List<Tag> tags, Instant timestamp) {
        MetricsLogger metricsLogger = new MetricsLogger(this.environment).setNamespace(NAMESPACE).setTimestamp(timestamp);
        this.addDimensionSet(tags, metricsLogger);
        this.addAdditionalProperties(metricsLogger);
        return metricsLogger;
    }

    private void addDimensionSet(List<Tag> tags, MetricsLogger metricsLogger) {
        metricsLogger.setDimensions(new DimensionSet[]{this.toDimensionSet(tags)});
    }

    private void addAdditionalProperties(MetricsLogger metricsLogger) {
        this.config.additionalProperties().forEach((arg_0, arg_1) -> ((MetricsLogger)metricsLogger).putProperty(arg_0, arg_1));
    }

    private DimensionSet toDimensionSet(List<Tag> tags) {
        DimensionSet dimensionSet = new DimensionSet();
        tags.stream().filter(this::isAcceptableTag).forEach(tag -> dimensionSet.addDimension(tag.getKey(), tag.getValue()));
        return dimensionSet;
    }

    private boolean isAcceptableTag(Tag tag) {
        if (StringUtils.isBlank((String)tag.getValue())) {
            warnThenDebugLogger.log("Dropping a tag with key '" + tag.getKey() + "' because its value is blank.");
            return false;
        }
        return true;
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static {
        HashMap<String, Unit> unitByLowercaseValue = new HashMap<String, Unit>();
        for (Unit unit : Unit.values()) {
            if (unit == Unit.UNKNOWN_TO_SDK_VERSION) continue;
            unitByLowercaseValue.put(unit.toString().toLowerCase(), unit);
        }
        UNIT_BY_LOWERCASE_VALUE = Collections.unmodifiableMap(unitByLowercaseValue);
        warnThenDebugLogger = new WarnThenDebugLogger(EMFLoggingMeterRegistry.class);
    }

    static class MetricDataPoint {
        String key;
        double value;
        Unit unit;

        MetricDataPoint(String key, double value, Unit unit) {
            this.key = key;
            this.value = value;
            this.unit = unit;
        }
    }

    class Snapshot {
        final Instant timestamp;

        Snapshot() {
            this.timestamp = Instant.ofEpochMilli(EMFLoggingMeterRegistry.this.clock.wallTime());
        }

        Stream<MetricDataPoint> gaugeData(Gauge gauge) {
            return Stream.ofNullable(this.metricDataPoint(gauge.getId(), "value", gauge.value()));
        }

        Stream<MetricDataPoint> counterData(Counter counter) {
            return Stream.ofNullable(this.metricDataPoint(counter.getId(), "count", Unit.COUNT, counter.count()));
        }

        Stream<MetricDataPoint> timerData(Timer timer) {
            Stream.Builder<MetricDataPoint> metrics = Stream.builder();
            metrics.add(this.metricDataPoint(timer.getId(), "sum", EMFLoggingMeterRegistry.this.getBaseTimeUnit().name(), timer.totalTime(EMFLoggingMeterRegistry.this.getBaseTimeUnit())));
            long count = timer.count();
            metrics.add(this.metricDataPoint(timer.getId(), "count", Unit.COUNT, (double)count));
            if (count > 0L) {
                metrics.add(this.metricDataPoint(timer.getId(), "avg", EMFLoggingMeterRegistry.this.getBaseTimeUnit().name(), timer.mean(EMFLoggingMeterRegistry.this.getBaseTimeUnit())));
                metrics.add(this.metricDataPoint(timer.getId(), "max", EMFLoggingMeterRegistry.this.getBaseTimeUnit().name(), timer.max(EMFLoggingMeterRegistry.this.getBaseTimeUnit())));
            }
            return metrics.build();
        }

        Stream<MetricDataPoint> summaryData(DistributionSummary summary) {
            Stream.Builder<MetricDataPoint> metrics = Stream.builder();
            metrics.add(this.metricDataPoint(summary.getId(), "sum", summary.totalAmount()));
            long count = summary.count();
            metrics.add(this.metricDataPoint(summary.getId(), "count", Unit.COUNT, (double)count));
            if (count > 0L) {
                metrics.add(this.metricDataPoint(summary.getId(), "avg", summary.mean()));
                metrics.add(this.metricDataPoint(summary.getId(), "max", summary.max()));
            }
            return metrics.build();
        }

        Stream<MetricDataPoint> longTaskTimerData(LongTaskTimer longTaskTimer) {
            Stream.Builder<MetricDataPoint> metrics = Stream.builder();
            metrics.add(this.metricDataPoint(longTaskTimer.getId(), "activeTasks", longTaskTimer.activeTasks()));
            metrics.add(this.metricDataPoint(longTaskTimer.getId(), "duration", longTaskTimer.duration(EMFLoggingMeterRegistry.this.getBaseTimeUnit())));
            return metrics.build();
        }

        Stream<MetricDataPoint> timeGaugeData(TimeGauge gauge) {
            return Stream.ofNullable(this.metricDataPoint(gauge.getId(), "value", gauge.value(EMFLoggingMeterRegistry.this.getBaseTimeUnit())));
        }

        Stream<MetricDataPoint> functionCounterData(FunctionCounter counter) {
            return Stream.ofNullable(this.metricDataPoint(counter.getId(), "count", Unit.COUNT, counter.count()));
        }

        Stream<MetricDataPoint> functionTimerData(FunctionTimer timer) {
            Stream.Builder<MetricDataPoint> metrics = Stream.builder();
            double sum = timer.totalTime(EMFLoggingMeterRegistry.this.getBaseTimeUnit());
            if (!Double.isFinite(sum)) {
                return Stream.empty();
            }
            double count = timer.count();
            metrics.add(this.metricDataPoint(timer.getId(), "count", Unit.COUNT, count));
            metrics.add(this.metricDataPoint(timer.getId(), "sum", sum));
            if (count > 0.0) {
                metrics.add(this.metricDataPoint(timer.getId(), "avg", timer.mean(EMFLoggingMeterRegistry.this.getBaseTimeUnit())));
            }
            return metrics.build();
        }

        Stream<MetricDataPoint> metricData(Meter m) {
            return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> this.metricDataPoint(m.getId().withTag(ms.getStatistic()), ms.getValue())).filter(Objects::nonNull);
        }

        private MetricDataPoint metricDataPoint(Meter.Id id, double value) {
            return this.metricDataPoint(id, null, id.getBaseUnit(), value);
        }

        private MetricDataPoint metricDataPoint(Meter.Id id, @Nullable String suffix, double value) {
            return this.metricDataPoint(id, suffix, id.getBaseUnit(), value);
        }

        private MetricDataPoint metricDataPoint(Meter.Id id, @Nullable String suffix, @Nullable String unit, double value) {
            return this.metricDataPoint(id, suffix, this.toUnit(unit), value);
        }

        private MetricDataPoint metricDataPoint(Meter.Id id, @Nullable String suffix, Unit unit, double value) {
            if (Double.isNaN(value)) {
                return null;
            }
            return new MetricDataPoint(this.getMetricName(id, suffix), EMFMetricUtils.clampMetricValue(value), unit);
        }

        String getMetricName(Meter.Id id, @Nullable String suffix) {
            String name = suffix != null ? id.getName() + "." + suffix : id.getName();
            return EMFLoggingMeterRegistry.this.config().namingConvention().name(name, id.getType(), id.getBaseUnit());
        }

        Unit toUnit(@Nullable String unit) {
            if (unit == null) {
                return Unit.NONE;
            }
            Unit unitObject = UNIT_BY_LOWERCASE_VALUE.get(unit.toLowerCase());
            return unitObject != null ? unitObject : Unit.NONE;
        }
    }
}

