/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.breaker;

import io.micrometer.core.instrument.Metrics;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.core.breaker.InnerCircuitBreaker;
import org.opensearch.dataprepper.core.parser.model.HeapCircuitBreakerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeapCircuitBreaker
implements InnerCircuitBreaker,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HeapCircuitBreaker.class);
    public static final int OPEN_METRIC_VALUE = 1;
    public static final int CLOSED_METRIC_VALUE = 0;
    private final MemoryMXBean memoryMXBean;
    private final long usageBytes;
    private final Duration resetPeriod;
    private final Lock lock;
    private final AtomicInteger openGauge;
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile boolean open;
    private Instant resetTime;

    HeapCircuitBreaker(HeapCircuitBreakerConfig circuitBreakerConfig) {
        this(circuitBreakerConfig, ManagementFactory.getMemoryMXBean());
    }

    HeapCircuitBreaker(HeapCircuitBreakerConfig circuitBreakerConfig, MemoryMXBean memoryMXBean) {
        Objects.requireNonNull(circuitBreakerConfig);
        Objects.requireNonNull(circuitBreakerConfig.getUsage());
        this.usageBytes = circuitBreakerConfig.getUsage().getBytes();
        if (this.usageBytes <= 0L) {
            throw new IllegalArgumentException("Bytes usage must be positive.");
        }
        this.resetPeriod = Objects.requireNonNull(circuitBreakerConfig.getReset());
        this.memoryMXBean = memoryMXBean;
        this.open = false;
        this.lock = new ReentrantLock();
        this.resetTime = Instant.MIN;
        Metrics.gauge((String)"core.circuitBreakers.heap.memoryUsage", (Object)this, cb -> this.getUsedMemoryBytes());
        this.openGauge = (AtomicInteger)Metrics.gauge((String)"core.circuitBreakers.heap.open", (Number)new AtomicInteger(0));
        Duration checkInterval = Objects.requireNonNull(circuitBreakerConfig.getCheckInterval());
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleAtFixedRate(this::checkMemory, 0L, checkInterval.toMillis(), TimeUnit.MILLISECONDS);
        LOG.info("Circuit breaker heap limit is set to {} bytes.", (Object)this.usageBytes);
    }

    public boolean isOpen() {
        return this.open;
    }

    private void checkMemory() {
        boolean previousOpen = this.open;
        if (previousOpen && Instant.now().compareTo(this.resetTime) < 0) {
            return;
        }
        long usedMemoryBytes = this.getUsedMemoryBytes();
        if (usedMemoryBytes > this.usageBytes) {
            this.open = true;
            if (!previousOpen) {
                System.gc();
                this.resetTime = Instant.now().plus(this.resetPeriod);
                this.openGauge.set(1);
                LOG.info("Circuit breaker tripped and open. {} used memory bytes > {} configured", (Object)usedMemoryBytes, (Object)this.usageBytes);
            }
        } else {
            this.open = false;
            if (previousOpen) {
                this.openGauge.set(0);
                LOG.info("Circuit breaker closed. {} used memory bytes <= {} configured", (Object)usedMemoryBytes, (Object)this.usageBytes);
            }
        }
    }

    private long getUsedMemoryBytes() {
        return this.memoryMXBean.getHeapMemoryUsage().getUsed();
    }

    @Override
    public void close() throws Exception {
        this.scheduledExecutorService.shutdown();
    }
}

