/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.acknowledgements;

import io.micrometer.core.instrument.Counter;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class DefaultAcknowledgementSetMetrics {
    static final String CREATED_METRIC_NAME = "numberOfAcknowledgementSetsCreated";
    static final String COMPLETED_METRIC_NAME = "numberOfAcknowledgementSetsCompleted";
    static final String EXPIRED_METRIC_NAME = "numberOfAcknowledgementSetsExpired";
    static final String INVALID_ACQUIRES_METRIC_NAME = "numberOfInvalidAcknowledgementAcquires";
    static final String INVALID_RELEASES_METRIC_NAME = "numberOfInvalidAcknowledgementReleases";
    private final Counter numberOfAcknowledgementSetsCreated;
    private final Counter numberOfAcknowledgementSetsCompleted;
    private final Counter numberOfAcknowledgementSetsExpired;
    private final Counter numberOfInvalidAcknowledgementAcquires;
    private final Counter numberOfInvalidAcknowledgementReleases;

    public DefaultAcknowledgementSetMetrics(PluginMetrics pluginMetrics) {
        this.numberOfAcknowledgementSetsCreated = pluginMetrics.counter(CREATED_METRIC_NAME);
        this.numberOfAcknowledgementSetsCompleted = pluginMetrics.counter(COMPLETED_METRIC_NAME);
        this.numberOfAcknowledgementSetsExpired = pluginMetrics.counter(EXPIRED_METRIC_NAME);
        this.numberOfInvalidAcknowledgementAcquires = pluginMetrics.counter(INVALID_ACQUIRES_METRIC_NAME);
        this.numberOfInvalidAcknowledgementReleases = pluginMetrics.counter(INVALID_RELEASES_METRIC_NAME);
    }

    public void increment(String metricName) throws IllegalArgumentException {
        switch (metricName) {
            case "numberOfAcknowledgementSetsCreated": {
                this.numberOfAcknowledgementSetsCreated.increment();
                break;
            }
            case "numberOfAcknowledgementSetsCompleted": {
                this.numberOfAcknowledgementSetsCompleted.increment();
                break;
            }
            case "numberOfAcknowledgementSetsExpired": {
                this.numberOfAcknowledgementSetsExpired.increment();
                break;
            }
            case "numberOfInvalidAcknowledgementAcquires": {
                this.numberOfInvalidAcknowledgementAcquires.increment();
                break;
            }
            case "numberOfInvalidAcknowledgementReleases": {
                this.numberOfInvalidAcknowledgementReleases.increment();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid metric name");
            }
        }
    }
}

