/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.DataPrepperShutdownListener;
import org.opensearch.dataprepper.DataPrepperShutdownOptions;
import org.opensearch.dataprepper.core.parser.PipelineTransformer;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderServer;
import org.opensearch.dataprepper.core.pipeline.Pipeline;
import org.opensearch.dataprepper.core.pipeline.PipelineObserver;
import org.opensearch.dataprepper.core.pipeline.PipelinesProvider;
import org.opensearch.dataprepper.core.pipeline.server.DataPrepperServer;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

@Named
public class DataPrepper
implements PipelinesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepper.class);
    private static final String DATAPREPPER_SERVICE_NAME = "DATAPREPPER_SERVICE_NAME";
    private static final String DEFAULT_SERVICE_NAME = "dataprepper";
    private final PluginFactory pluginFactory;
    private final PeerForwarderServer peerForwarderServer;
    private final PipelinesObserver pipelinesObserver;
    private final Map<String, Pipeline> transformationPipelines;
    private final Predicate<Map<String, Pipeline>> shouldShutdownOnPipelineFailurePredicate;
    private final PipelinesDataFlowModel pipelinesDataFlowModel;
    @Inject
    @Lazy
    private DataPrepperServer dataPrepperServer;
    private final List<DataPrepperShutdownListener> shutdownListeners = new LinkedList<DataPrepperShutdownListener>();

    public static String getServiceNameForMetrics() {
        String serviceName = System.getenv(DATAPREPPER_SERVICE_NAME);
        return serviceName != null && !serviceName.trim().isEmpty() ? serviceName : DEFAULT_SERVICE_NAME;
    }

    @Inject
    public DataPrepper(PipelinesDataFlowModel pipelinesDataFlowModel, PipelineTransformer pipelineTransformer, PluginFactory pluginFactory, PeerForwarderServer peerForwarderServer, Predicate<Map<String, Pipeline>> shouldShutdownOnPipelineFailurePredicate) {
        this.pluginFactory = pluginFactory;
        this.pipelinesDataFlowModel = pipelinesDataFlowModel;
        this.transformationPipelines = pipelineTransformer.transformConfiguration(pipelinesDataFlowModel);
        this.shouldShutdownOnPipelineFailurePredicate = shouldShutdownOnPipelineFailurePredicate;
        if (this.transformationPipelines.isEmpty()) {
            throw new RuntimeException("No valid pipeline is available for execution, exiting");
        }
        this.peerForwarderServer = peerForwarderServer;
        this.pipelinesObserver = new PipelinesObserver();
    }

    public boolean execute() {
        this.peerForwarderServer.start();
        this.transformationPipelines.forEach((name, pipeline) -> pipeline.addShutdownObserver(this.pipelinesObserver));
        this.transformationPipelines.forEach((name, pipeline) -> pipeline.execute());
        this.dataPrepperServer.start();
        return true;
    }

    public void shutdown() {
        this.shutdownPipelines();
        this.shutdownServers();
    }

    public Pipeline getPipeline(String pipelineName) {
        return this.transformationPipelines.get(pipelineName);
    }

    private void shutdownPipelines() {
        this.shutdownPipelines(DataPrepperShutdownOptions.defaultOptions());
    }

    public void shutdownPipelines(DataPrepperShutdownOptions shutdownOptions) {
        this.transformationPipelines.forEach((name, pipeline) -> pipeline.removeShutdownObserver(this.pipelinesObserver));
        for (Pipeline pipeline2 : this.transformationPipelines.values()) {
            LOG.info("Shutting down pipeline: {}", (Object)pipeline2.getName());
            pipeline2.shutdown(shutdownOptions);
        }
    }

    public void shutdownServers() {
        this.dataPrepperServer.stop();
        this.peerForwarderServer.stop();
        if (this.shutdownListeners != null) {
            this.shutdownListeners.forEach(DataPrepperShutdownListener::handleShutdown);
        }
    }

    public void shutdownPipeline(String pipeline) {
        if (this.transformationPipelines.containsKey(pipeline)) {
            this.transformationPipelines.get(pipeline).shutdown();
        }
    }

    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    @Override
    public Map<String, Pipeline> getTransformationPipelines() {
        return this.transformationPipelines;
    }

    @Override
    public PipelinesDataFlowModel getPipelinesDataFlowModel() {
        return this.pipelinesDataFlowModel;
    }

    public void registerShutdownHandler(DataPrepperShutdownListener shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }

    private class PipelinesObserver
    implements PipelineObserver {
        private PipelinesObserver() {
        }

        @Override
        public void shutdown(Pipeline pipeline) {
            pipeline.removeShutdownObserver(DataPrepper.this.pipelinesObserver);
            DataPrepper.this.transformationPipelines.remove(pipeline.getName());
            LOG.info("Pipeline has shutdown. '{}'. There are {} pipelines remaining.", (Object)pipeline.getName(), (Object)DataPrepper.this.transformationPipelines.size());
            if (DataPrepper.this.shouldShutdownOnPipelineFailurePredicate.test(DataPrepper.this.transformationPipelines)) {
                DataPrepper.this.shutdown();
            }
        }
    }
}

