/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.parser;

import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.opensearch.dataprepper.plugins.source.s3.S3EventBridgeNotification;
import org.opensearch.dataprepper.plugins.source.s3.S3EventNotification;
import software.amazon.awssdk.services.sqs.model.Message;

public class ParsedMessage {
    private final Message message;
    private boolean failedParsing;
    private String bucketName;
    private String objectKey;
    private long objectSize;
    private String eventName;
    private DateTime eventTime;
    private boolean emptyNotification;
    private String detailType;
    private boolean shouldSkipProcessing;

    public ParsedMessage(Message message, boolean failedParsing) {
        this.message = Objects.requireNonNull(message);
        this.failedParsing = failedParsing;
        this.emptyNotification = true;
    }

    ParsedMessage(Message message, List<S3EventNotification.S3EventNotificationRecord> notificationRecords) {
        this.message = Objects.requireNonNull(message);
        this.bucketName = notificationRecords.get(0).getS3().getBucket().getName();
        this.objectKey = notificationRecords.get(0).getS3().getObject().getUrlDecodedKey();
        Long size = notificationRecords.get(0).getS3().getObject().getSizeAsLong();
        this.objectSize = size != null ? size : 0L;
        this.eventName = notificationRecords.get(0).getEventName();
        this.eventTime = notificationRecords.get(0).getEventTime();
        this.failedParsing = false;
        this.emptyNotification = notificationRecords.isEmpty();
        this.shouldSkipProcessing = false;
    }

    ParsedMessage(Message message, S3EventBridgeNotification eventBridgeNotification) {
        this.message = Objects.requireNonNull(message);
        this.bucketName = eventBridgeNotification.getDetail().getBucket().getName();
        this.objectKey = eventBridgeNotification.getDetail().getObject().getUrlDecodedKey();
        this.objectSize = eventBridgeNotification.getDetail().getObject().getSize();
        this.detailType = eventBridgeNotification.getDetailType();
        this.eventTime = eventBridgeNotification.getTime();
        this.shouldSkipProcessing = false;
    }

    public Message getMessage() {
        return this.message;
    }

    public boolean isFailedParsing() {
        return this.failedParsing;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public long getObjectSize() {
        return this.objectSize;
    }

    public String getEventName() {
        return this.eventName;
    }

    public DateTime getEventTime() {
        return this.eventTime;
    }

    public boolean isEmptyNotification() {
        return this.emptyNotification;
    }

    public String getDetailType() {
        return this.detailType;
    }

    public boolean isShouldSkipProcessing() {
        return this.shouldSkipProcessing;
    }

    public void setShouldSkipProcessing(boolean shouldSkipProcessing) {
        this.shouldSkipProcessing = shouldSkipProcessing;
    }

    public String toString() {
        return "Message{messageId=" + this.message.messageId() + ", objectKey=" + this.objectKey + "}";
    }
}

