/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum S3DataSelection {
    DATA_ONLY("data_only"),
    METADATA_ONLY("metadata_only"),
    DATA_AND_METADATA("data_and_metadata");

    private static final Map<String, S3DataSelection> S3_DATA_SELECTION_MAP;
    private final String type;

    private S3DataSelection(String type) {
        this.type = type;
    }

    @JsonCreator
    public static S3DataSelection fromOptionValue(String name) {
        return S3_DATA_SELECTION_MAP.get(name);
    }

    static {
        S3_DATA_SELECTION_MAP = Arrays.stream(S3DataSelection.values()).collect(Collectors.toMap(value -> value.type, value -> value));
    }
}

