/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.stream.Stream;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanBucketOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanOptions {
    private static final Logger LOG = LoggerFactory.getLogger(ScanOptions.class);
    private final LocalDateTime startDateTime;
    private final Duration range;
    private final S3ScanBucketOption bucketOption;
    private final LocalDateTime endDateTime;
    private final LocalDateTime useStartDateTime;
    private final LocalDateTime useEndDateTime;

    private ScanOptions(Builder builder) {
        this.startDateTime = builder.startDateTime;
        this.range = builder.range;
        this.bucketOption = builder.bucketOption;
        this.endDateTime = builder.endDateTime;
        this.useStartDateTime = builder.useStartDateTime;
        this.useEndDateTime = builder.useEndDateTime;
    }

    public S3ScanBucketOption getBucketOption() {
        return this.bucketOption;
    }

    public LocalDateTime getUseStartDateTime() {
        return this.useStartDateTime;
    }

    public LocalDateTime getUseEndDateTime() {
        return this.useEndDateTime;
    }

    public String toString() {
        return "startDateTime=" + String.valueOf(this.startDateTime) + ", range=" + String.valueOf(this.range) + ", endDateTime=" + String.valueOf(this.endDateTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LocalDateTime startDateTime;
        private Duration range;
        private S3ScanBucketOption bucketOption;
        private LocalDateTime endDateTime;
        private LocalDateTime useStartDateTime;
        private LocalDateTime useEndDateTime;

        public Builder setStartDateTime(LocalDateTime startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public Builder setRange(Duration range) {
            this.range = range;
            return this;
        }

        public Builder setEndDateTime(LocalDateTime endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public Builder setBucketOption(S3ScanBucketOption bucketOption) {
            this.bucketOption = bucketOption;
            return this;
        }

        public ScanOptions build() {
            long globalLevelNonNullCount = Stream.of(this.startDateTime, this.endDateTime, this.range).filter(x$0 -> Objects.nonNull(x$0)).count();
            long originalBucketLevelNonNullCount = Stream.of(this.bucketOption.getStartTime(), this.bucketOption.getEndTime(), this.bucketOption.getRange()).filter(x$0 -> Objects.nonNull(x$0)).count();
            if (originalBucketLevelNonNullCount != 0L) {
                this.setDateTimeToUse(this.bucketOption.getStartTime(), this.bucketOption.getEndTime(), this.bucketOption.getRange());
            } else if (globalLevelNonNullCount != 0L) {
                this.setDateTimeToUse(this.startDateTime, this.endDateTime, this.range);
            }
            return new ScanOptions(this);
        }

        private void setDateTimeToUse(LocalDateTime bucketStartDateTime, LocalDateTime bucketEndDateTime, Duration bucketRange) {
            if (Objects.nonNull(bucketStartDateTime) && Objects.nonNull(bucketEndDateTime)) {
                this.useStartDateTime = bucketStartDateTime;
                this.useEndDateTime = bucketEndDateTime;
                LOG.info("Scanning objects modified from {} to {} from bucket: {}", new Object[]{this.useStartDateTime, this.useEndDateTime, this.bucketOption.getName()});
            } else if (Objects.nonNull(bucketStartDateTime)) {
                this.useStartDateTime = bucketStartDateTime;
                LOG.info("Scanning objects modified after {} from bucket: {}", (Object)this.useStartDateTime, (Object)this.bucketOption.getName());
            } else if (Objects.nonNull(bucketEndDateTime)) {
                this.useEndDateTime = bucketEndDateTime;
                LOG.info("Scanning objects modified before {} from bucket: {}", (Object)this.useEndDateTime, (Object)this.bucketOption.getName());
            } else if (Objects.nonNull(bucketRange)) {
                this.useEndDateTime = LocalDateTime.now();
                this.useStartDateTime = this.useEndDateTime.minus(bucketRange);
                LOG.info("Scanning objects modified from {} to {} from bucket: {}", new Object[]{this.useStartDateTime, this.useEndDateTime, this.bucketOption.getName()});
            } else {
                LOG.info("Scanning all objects from bucket: {}", (Object)this.bucketOption.getName());
            }
        }

        public String toString() {
            return "startDateTime=" + String.valueOf(this.startDateTime) + ", range=" + String.valueOf(this.range) + ", endDateTime=" + String.valueOf(this.endDateTime);
        }
    }
}

