/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.UsesSourceCoordination;
import org.opensearch.dataprepper.plugins.source.s3.AwsAuthenticationAdapter;
import org.opensearch.dataprepper.plugins.source.s3.EventMetadataModifier;
import org.opensearch.dataprepper.plugins.source.s3.S3ClientBuilderFactory;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectDeleteWorker;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectHandler;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectPluginMetrics;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectRequest;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectWorker;
import org.opensearch.dataprepper.plugins.source.s3.S3ScanService;
import org.opensearch.dataprepper.plugins.source.s3.S3SelectObjectWorker;
import org.opensearch.dataprepper.plugins.source.s3.S3SelectResponseHandlerFactory;
import org.opensearch.dataprepper.plugins.source.s3.S3Service;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceProgressState;
import org.opensearch.dataprepper.plugins.source.s3.SqsService;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanScanOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectCSVOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectJsonOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectOptions;
import org.opensearch.dataprepper.plugins.source.s3.ownership.BucketOwnerProvider;
import org.opensearch.dataprepper.plugins.source.s3.ownership.ConfigBucketOwnerProviderFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.model.CompressionType;

@DataPrepperPlugin(name="s3", pluginType=Source.class, pluginConfigurationType=S3SourceConfig.class)
public class S3Source
implements Source<Record<Event>>,
UsesSourceCoordination {
    private final PluginMetrics pluginMetrics;
    private final S3SourceConfig s3SourceConfig;
    private SqsService sqsService;
    private S3ScanService s3ScanService;
    private final PluginFactory pluginFactory;
    private final Optional<S3ScanScanOptions> s3ScanScanOptional;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private final boolean acknowledgementsEnabled;
    private SourceCoordinator<S3SourceProgressState> sourceCoordinator;

    @DataPrepperPluginConstructor
    public S3Source(PluginMetrics pluginMetrics, S3SourceConfig s3SourceConfig, PluginFactory pluginFactory, AcknowledgementSetManager acknowledgementSetManager, AwsCredentialsSupplier awsCredentialsSupplier) {
        this.pluginMetrics = pluginMetrics;
        this.s3SourceConfig = s3SourceConfig;
        this.pluginFactory = pluginFactory;
        this.s3ScanScanOptional = Optional.ofNullable(s3SourceConfig.getS3ScanScanOptions());
        this.acknowledgementsEnabled = s3SourceConfig.getAcknowledgements();
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
    }

    public boolean areAcknowledgementsEnabled() {
        return this.acknowledgementsEnabled;
    }

    public void start(Buffer<Record<Event>> buffer) {
        S3ObjectHandler s3Handler;
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        AwsAuthenticationAdapter awsAuthenticationAdapter = new AwsAuthenticationAdapter(this.awsCredentialsSupplier, this.s3SourceConfig);
        AwsCredentialsProvider credentialsProvider = awsAuthenticationAdapter.getCredentialsProvider();
        ConfigBucketOwnerProviderFactory configBucketOwnerProviderFactory = new ConfigBucketOwnerProviderFactory(credentialsProvider);
        BucketOwnerProvider bucketOwnerProvider = configBucketOwnerProviderFactory.createBucketOwnerProvider(this.s3SourceConfig);
        Optional<S3SelectOptions> s3SelectOptional = Optional.ofNullable(this.s3SourceConfig.getS3SelectOptions());
        S3ObjectPluginMetrics s3ObjectPluginMetrics = new S3ObjectPluginMetrics(this.pluginMetrics);
        S3ClientBuilderFactory s3ClientBuilderFactory = new S3ClientBuilderFactory(this.s3SourceConfig, credentialsProvider);
        S3ObjectRequest.Builder s3ObjectRequestBuilder = new S3ObjectRequest.Builder(buffer, this.s3SourceConfig.getNumberOfRecordsToAccumulate(), this.s3SourceConfig.getBufferTimeout(), s3ObjectPluginMetrics);
        EventMetadataModifier eventMetadataModifier = new EventMetadataModifier(this.s3SourceConfig.getMetadataRootKey(), this.s3SourceConfig.isDeleteS3MetadataInEvent());
        S3ObjectDeleteWorker s3ObjectDeleteWorker = new S3ObjectDeleteWorker(s3ClientBuilderFactory.getS3Client(), this.pluginMetrics);
        if (s3SelectOptional.isPresent()) {
            S3SelectCSVOption csvOption = s3SelectOptional.get().getS3SelectCSVOption() != null ? s3SelectOptional.get().getS3SelectCSVOption() : new S3SelectCSVOption();
            S3SelectJsonOption jsonOption = s3SelectOptional.get().getS3SelectJsonOption() != null ? s3SelectOptional.get().getS3SelectJsonOption() : new S3SelectJsonOption();
            S3ObjectRequest s3ObjectRequest = s3ObjectRequestBuilder.expression(s3SelectOptional.get().getExpression()).serializationFormatOption(s3SelectOptional.get().getS3SelectSerializationFormatOption()).s3AsyncClient(s3ClientBuilderFactory.getS3AsyncClient()).eventConsumer(eventMetadataModifier).bucketOwnerProvider(bucketOwnerProvider).s3SelectCSVOption(csvOption).s3SelectJsonOption(jsonOption).expressionType(s3SelectOptional.get().getExpressionType()).compressionType(CompressionType.valueOf((String)s3SelectOptional.get().getCompressionType().toUpperCase())).s3SelectResponseHandlerFactory(new S3SelectResponseHandlerFactory()).build();
            s3Handler = new S3SelectObjectWorker(s3ObjectRequest);
        } else {
            PluginModel codecConfiguration = this.s3SourceConfig.getCodec();
            PluginSetting codecPluginSettings = new PluginSetting(codecConfiguration.getPluginName(), codecConfiguration.getPluginSettings());
            InputCodec codec = (InputCodec)this.pluginFactory.loadPlugin(InputCodec.class, codecPluginSettings, new Object[0]);
            S3ObjectRequest s3ObjectRequest = s3ObjectRequestBuilder.bucketOwnerProvider(bucketOwnerProvider).codec(codec).eventConsumer(eventMetadataModifier).s3Client(s3ClientBuilderFactory.getS3Client()).compressionOption(this.s3SourceConfig.getCompression()).build();
            s3Handler = new S3ObjectWorker(s3ObjectRequest);
        }
        if (Objects.nonNull(this.s3SourceConfig.getSqsOptions())) {
            S3Service s3Service = new S3Service(s3Handler);
            this.sqsService = new SqsService(this.acknowledgementSetManager, this.s3SourceConfig, s3Service, this.pluginMetrics, credentialsProvider);
            this.sqsService.start();
        }
        if (this.s3ScanScanOptional.isPresent()) {
            this.s3ScanService = new S3ScanService(this.s3SourceConfig, s3ClientBuilderFactory, s3Handler, bucketOwnerProvider, this.sourceCoordinator, this.acknowledgementSetManager, s3ObjectDeleteWorker, this.pluginMetrics);
            this.s3ScanService.start();
        }
    }

    public void stop() {
        if (Objects.nonNull(this.sqsService)) {
            this.sqsService.stop();
        }
        if (Objects.nonNull(this.s3ScanService) && Objects.nonNull(this.sourceCoordinator)) {
            this.s3ScanService.stop();
        }
    }

    public <T> void setSourceCoordinator(SourceCoordinator<T> sourceCoordinator) {
        this.sourceCoordinator = sourceCoordinator;
    }

    public Class<?> getPartitionProgressStateClass() {
        return S3SourceProgressState.class;
    }
}

