/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.opensearch.dataprepper.model.source.coordinator.PartitionIdentifier;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceProgressState;
import org.opensearch.dataprepper.plugins.source.s3.ScanOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.FolderPartitioningOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanKeyPathOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanSchedulingOptions;
import org.opensearch.dataprepper.plugins.source.s3.ownership.BucketOwnerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.Pair;

public class S3ScanPartitionCreationSupplier
implements Function<Map<String, Object>, List<PartitionIdentifier>> {
    private static final Logger LOG = LoggerFactory.getLogger(S3ScanPartitionCreationSupplier.class);
    private static final String BUCKET_OBJECT_PARTITION_KEY_FORMAT = "%s|%s";
    static final String SCAN_COUNT = "SCAN_COUNT";
    static final String LAST_SCAN_TIME = "LAST_SCAN_TIME";
    static final String SINGLE_SCAN_COMPLETE = "SINGLE_SCAN_COMPLETE";
    private final S3Client s3Client;
    private final BucketOwnerProvider bucketOwnerProvider;
    private final List<ScanOptions> scanOptionsList;
    private final S3ScanSchedulingOptions schedulingOptions;
    private final FolderPartitioningOptions folderPartitioningOptions;
    private final boolean deleteS3ObjectsOnRead;
    private final SourceCoordinator<S3SourceProgressState> sourceCoordinator;

    public S3ScanPartitionCreationSupplier(S3Client s3Client, BucketOwnerProvider bucketOwnerProvider, List<ScanOptions> scanOptionsList, S3ScanSchedulingOptions schedulingOptions, FolderPartitioningOptions folderPartitioningOptions, boolean deleteS3ObjectsOnRead, SourceCoordinator<S3SourceProgressState> sourceCoordinator) {
        this.s3Client = s3Client;
        this.bucketOwnerProvider = bucketOwnerProvider;
        this.scanOptionsList = scanOptionsList;
        this.schedulingOptions = schedulingOptions;
        this.folderPartitioningOptions = folderPartitioningOptions;
        this.deleteS3ObjectsOnRead = deleteS3ObjectsOnRead;
        this.sourceCoordinator = sourceCoordinator;
    }

    @Override
    public List<PartitionIdentifier> apply(Map<String, Object> globalStateMap) {
        if (globalStateMap.isEmpty()) {
            this.initializeGlobalStateMap(globalStateMap);
        }
        if (this.shouldScanBeSkipped(globalStateMap)) {
            return Collections.emptyList();
        }
        ArrayList objectsToProcess = new ArrayList();
        HashMap<String, String> bucketScanTime = new HashMap<String, String>();
        for (ScanOptions scanOptions : this.scanOptionsList) {
            String bucketName = scanOptions.getBucketOption().getName();
            ArrayList<String> excludeItems = new ArrayList<String>();
            S3ScanKeyPathOption s3ScanKeyPathOption = scanOptions.getBucketOption().getS3ScanFilter();
            ListObjectsV2Request.Builder listObjectsV2Request = ListObjectsV2Request.builder().bucket(bucketName);
            this.bucketOwnerProvider.getBucketOwner(bucketName).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)listObjectsV2Request).expectedBucketOwner(arg_0));
            Instant updatedScanTime = Instant.now();
            if (Objects.nonNull(s3ScanKeyPathOption) && Objects.nonNull(s3ScanKeyPathOption.getS3ScanExcludeSuffixOptions())) {
                excludeItems.addAll(s3ScanKeyPathOption.getS3ScanExcludeSuffixOptions());
            }
            if (Objects.nonNull(s3ScanKeyPathOption) && Objects.nonNull(s3ScanKeyPathOption.getS3scanIncludePrefixOptions())) {
                s3ScanKeyPathOption.getS3scanIncludePrefixOptions().forEach(includePath -> {
                    listObjectsV2Request.prefix(includePath);
                    this.createFilteredS3ObjectPartitionsForBucket(excludeItems, listObjectsV2Request, bucketName, scanOptions.getUseStartDateTime(), scanOptions.getUseEndDateTime(), globalStateMap);
                });
            } else {
                this.createFilteredS3ObjectPartitionsForBucket(excludeItems, listObjectsV2Request, bucketName, scanOptions.getUseStartDateTime(), scanOptions.getUseEndDateTime(), globalStateMap);
            }
            if (bucketScanTime.containsKey(bucketName)) continue;
            bucketScanTime.put(bucketName, updatedScanTime.toString());
        }
        globalStateMap.putAll(bucketScanTime);
        globalStateMap.put(SCAN_COUNT, (Integer)globalStateMap.get(SCAN_COUNT) + 1);
        globalStateMap.put(LAST_SCAN_TIME, Instant.now().toEpochMilli());
        return Collections.emptyList();
    }

    private void createFilteredS3ObjectPartitionsForBucket(List<String> excludeKeyPaths, ListObjectsV2Request.Builder listObjectsV2Request, String bucket, LocalDateTime startDateTime, LocalDateTime endDateTime, Map<String, Object> globalStateMap) {
        Instant previousScanTime = globalStateMap.get(bucket) != null ? Instant.parse((String)globalStateMap.get(bucket)) : null;
        boolean isFirstScan = previousScanTime == null;
        ListObjectsV2Response listObjectsV2Response = null;
        do {
            listObjectsV2Response = this.s3Client.listObjectsV2((ListObjectsV2Request)listObjectsV2Request.fetchOwner(Boolean.valueOf(true)).continuationToken(Objects.nonNull(listObjectsV2Response) ? listObjectsV2Response.nextContinuationToken() : null).build());
            List<PartitionIdentifier> partitionsForPage = listObjectsV2Response.contents().stream().filter(s3Object -> this.deleteS3ObjectsOnRead || this.isLastModifiedTimeAfterMostRecentScanForBucket(previousScanTime, (S3Object)s3Object)).map(s3Object -> Pair.of((Object)s3Object.key(), (Object)this.instantToLocalDateTime(s3Object.lastModified()))).filter(keyTimestampPair -> !((String)keyTimestampPair.left()).endsWith("/")).filter(keyTimestampPair -> excludeKeyPaths.stream().noneMatch(excludeItem -> ((String)keyTimestampPair.left()).endsWith((String)excludeItem))).filter(keyTimestampPair -> this.isKeyMatchedBetweenTimeRange((LocalDateTime)keyTimestampPair.right(), startDateTime, endDateTime, isFirstScan)).map(Pair::left).map(objectKey -> PartitionIdentifier.builder().withPartitionKey(String.format(BUCKET_OBJECT_PARTITION_KEY_FORMAT, bucket, objectKey)).build()).collect(Collectors.toList());
            LOG.info("Found page of {} objects from bucket {}", (Object)listObjectsV2Response.keyCount(), (Object)bucket);
            if (this.folderPartitioningOptions != null) {
                List<PartitionIdentifier> folderPartitionsForPage = this.getFolderPartitionIdentifiers(partitionsForPage);
                this.sourceCoordinator.createPartitions(folderPartitionsForPage);
                continue;
            }
            LOG.info("Creating partitions for {} S3 objects from bucket {}", (Object)partitionsForPage.size(), (Object)bucket);
            this.sourceCoordinator.createPartitions(partitionsForPage);
        } while (listObjectsV2Response.isTruncated().booleanValue());
    }

    private LocalDateTime instantToLocalDateTime(Instant instant) {
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        return zonedDateTime.toLocalDateTime();
    }

    private boolean isKeyMatchedBetweenTimeRange(LocalDateTime lastModifiedTime, LocalDateTime startDateTime, LocalDateTime endDateTime, boolean isFirstScan) {
        if (!isFirstScan && this.schedulingOptions != null) {
            if (startDateTime != null) {
                return lastModifiedTime.isAfter(startDateTime);
            }
            return true;
        }
        if (Objects.isNull(startDateTime) && Objects.isNull(endDateTime)) {
            return true;
        }
        if (Objects.isNull(startDateTime)) {
            return lastModifiedTime.isBefore(endDateTime);
        }
        if (Objects.isNull(endDateTime)) {
            return lastModifiedTime.isAfter(startDateTime);
        }
        return lastModifiedTime.isAfter(startDateTime) && lastModifiedTime.isBefore(endDateTime);
    }

    private void initializeGlobalStateMap(Map<String, Object> globalStateMap) {
        globalStateMap.put(SCAN_COUNT, 0);
        globalStateMap.put(SINGLE_SCAN_COMPLETE, false);
    }

    private boolean isLastModifiedTimeAfterMostRecentScanForBucket(Instant previousScanTime, S3Object s3Object) {
        if (previousScanTime == null) {
            return true;
        }
        return s3Object.lastModified().compareTo(previousScanTime) >= 0;
    }

    private boolean shouldScanBeSkipped(Map<String, Object> globalStateMap) {
        if (Objects.isNull(this.schedulingOptions) && this.hasAlreadyBeenScanned(globalStateMap)) {
            if (!((Boolean)globalStateMap.get(SINGLE_SCAN_COMPLETE)).booleanValue()) {
                LOG.info("Single S3 scan has already been completed");
                globalStateMap.put(SINGLE_SCAN_COMPLETE, true);
            }
            return true;
        }
        if (Objects.nonNull(this.schedulingOptions) && (this.hasReachedMaxScanCount(globalStateMap) || !this.hasReachedScheduledScanTime(globalStateMap))) {
            if (this.hasReachedMaxScanCount(globalStateMap)) {
                LOG.info("Skipping scan as the max scan count {} has been reached", (Object)this.schedulingOptions.getCount());
            } else {
                LOG.info("Skipping scan as the interval of {} seconds has not been reached yet", (Object)this.schedulingOptions.getInterval().toSeconds());
            }
            return true;
        }
        return false;
    }

    private boolean hasAlreadyBeenScanned(Map<String, Object> globalStateMap) {
        return (Integer)globalStateMap.get(SCAN_COUNT) > 0;
    }

    private boolean hasReachedMaxScanCount(Map<String, Object> globalStateMap) {
        return (Integer)globalStateMap.get(SCAN_COUNT) >= this.schedulingOptions.getCount();
    }

    private boolean hasReachedScheduledScanTime(Map<String, Object> globalStateMap) {
        if (!globalStateMap.containsKey(LAST_SCAN_TIME)) {
            return true;
        }
        return Instant.now().minus(this.schedulingOptions.getInterval()).isAfter(Instant.ofEpochMilli((Long)globalStateMap.get(LAST_SCAN_TIME)));
    }

    private String getPrefixWithDepth(String fullObjectKey) {
        String[] folders = fullObjectKey.split("/");
        if (folders.length < this.folderPartitioningOptions.getFolderDepth() + 1) {
            return null;
        }
        int actualDepth = NumberUtils.min((int[])new int[]{this.folderPartitioningOptions.getFolderDepth(), folders.length - 1});
        return String.join((CharSequence)"/", Arrays.copyOfRange(folders, 0, actualDepth)) + "/";
    }

    private List<PartitionIdentifier> getFolderPartitionIdentifiers(List<PartitionIdentifier> objectPartitionIdentifiers) {
        Set folderPartitions = objectPartitionIdentifiers.stream().map(partitionIdentifier -> {
            String fullObjectKey = partitionIdentifier.getPartitionKey();
            String prefix = this.getPrefixWithDepth(fullObjectKey);
            if (prefix == null) {
                return null;
            }
            return PartitionIdentifier.builder().withPartitionKey(prefix).build();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        LOG.info("Running in folder_partitions mode at depth {}, found {} unique prefixes from {} objects", new Object[]{this.folderPartitioningOptions.getFolderDepth(), folderPartitions.size(), objectPartitionIdentifiers.size()});
        return new ArrayList<PartitionIdentifier>(folderPartitions);
    }
}

