/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompareCondition
implements ConditionVariant,
JsonpSerializable {
    @Nullable
    private final String comparison;
    @Nullable
    private final String path;
    @Nullable
    private final JsonData value;
    public static final JsonpDeserializer<CompareCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompareCondition::setupCompareConditionDeserializer);

    private CompareCondition(Builder builder) {
        this.comparison = builder.comparison;
        this.path = builder.path;
        this.value = builder.value;
    }

    public static CompareCondition of(Function<Builder, ObjectBuilder<CompareCondition>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Condition.Kind _conditionKind() {
        return Condition.Kind.Compare;
    }

    @Nullable
    public final String comparison() {
        return this.comparison;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Nullable
    public final JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.comparison != null) {
            generator.writeKey("comparison");
            generator.write(this.comparison);
        }
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
    }

    protected static void setupCompareConditionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::comparison, JsonpDeserializer.stringDeserializer(), "comparison");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CompareCondition> {
        @Nullable
        private String comparison;
        @Nullable
        private String path;
        @Nullable
        private JsonData value;

        public final Builder comparison(@Nullable String value) {
            this.comparison = value;
            return this;
        }

        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        public final Builder value(@Nullable JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        public CompareCondition build() {
            this._checkSingleUse();
            return new CompareCondition(this);
        }
    }
}

