/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewTransformResponse<TTransform>
implements JsonpSerializable {
    private final IndexState generatedDestIndex;
    private final List<TTransform> preview;
    @Nullable
    private final JsonpSerializer<TTransform> tTransformSerializer;
    public static final JsonpDeserializer<PreviewTransformResponse<Object>> _DESERIALIZER = PreviewTransformResponse.createPreviewTransformResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:transform.preview_transform.TTransform"));

    private PreviewTransformResponse(Builder<TTransform> builder) {
        this.generatedDestIndex = ApiTypeHelper.requireNonNull(((Builder)builder).generatedDestIndex, this, "generatedDestIndex");
        this.preview = ApiTypeHelper.unmodifiableRequired(((Builder)builder).preview, (Object)this, "preview");
        this.tTransformSerializer = ((Builder)builder).tTransformSerializer;
    }

    public static <TTransform> PreviewTransformResponse<TTransform> of(Function<Builder<TTransform>, ObjectBuilder<PreviewTransformResponse<TTransform>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final IndexState generatedDestIndex() {
        return this.generatedDestIndex;
    }

    public final List<TTransform> preview() {
        return this.preview;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("generated_dest_index");
        this.generatedDestIndex.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.preview)) {
            generator.writeKey("preview");
            generator.writeStartArray();
            for (TTransform item0 : this.preview) {
                JsonpUtils.serialize(item0, generator, this.tTransformSerializer, mapper);
            }
            generator.writeEnd();
        }
    }

    public static <TTransform> JsonpDeserializer<PreviewTransformResponse<TTransform>> createPreviewTransformResponseDeserializer(JsonpDeserializer<TTransform> tTransformDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> PreviewTransformResponse.setupPreviewTransformResponseDeserializer(op, tTransformDeserializer));
    }

    protected static <TTransform> void setupPreviewTransformResponseDeserializer(ObjectDeserializer<Builder<TTransform>> op, JsonpDeserializer<TTransform> tTransformDeserializer) {
        op.add(Builder::generatedDestIndex, IndexState._DESERIALIZER, "generated_dest_index");
        op.add(Builder::preview, JsonpDeserializer.arrayDeserializer(tTransformDeserializer), "preview");
    }

    public static class Builder<TTransform>
    extends ObjectBuilderBase
    implements ObjectBuilder<PreviewTransformResponse<TTransform>> {
        private IndexState generatedDestIndex;
        private List<TTransform> preview;
        @Nullable
        private JsonpSerializer<TTransform> tTransformSerializer;

        public final Builder<TTransform> generatedDestIndex(IndexState value) {
            this.generatedDestIndex = value;
            return this;
        }

        public final Builder<TTransform> generatedDestIndex(Function<IndexState.Builder, ObjectBuilder<IndexState>> fn) {
            return this.generatedDestIndex(fn.apply(new IndexState.Builder()).build());
        }

        public final Builder<TTransform> preview(List<TTransform> list) {
            this.preview = Builder._listAddAll(this.preview, list);
            return this;
        }

        public final Builder<TTransform> preview(TTransform value, TTransform ... values) {
            this.preview = Builder._listAdd(this.preview, value, values);
            return this;
        }

        public final Builder<TTransform> tTransformSerializer(@Nullable JsonpSerializer<TTransform> value) {
            this.tTransformSerializer = value;
            return this;
        }

        @Override
        public PreviewTransformResponse<TTransform> build() {
            this._checkSingleUse();
            return new PreviewTransformResponse(this);
        }
    }
}

