/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.PutRoleMappingResponse;
import co.elastic.clients.elasticsearch.security.RoleMappingRule;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutRoleMappingRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean enabled;
    private final Map<String, JsonData> metadata;
    private final String name;
    @Nullable
    private final Refresh refresh;
    private final List<String> roles;
    @Nullable
    private final RoleMappingRule rules;
    private final List<String> runAs;
    public static final JsonpDeserializer<PutRoleMappingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRoleMappingRequest::setupPutRoleMappingRequestDeserializer);
    public static final Endpoint<PutRoleMappingRequest, PutRoleMappingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRoleMappingRequest, PutRoleMappingResponse>("es/security.put_role_mapping", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutRoleMappingResponse._DESERIALIZER);

    private PutRoleMappingRequest(Builder builder) {
        this.enabled = builder.enabled;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.refresh = builder.refresh;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.rules = builder.rules;
        this.runAs = ApiTypeHelper.unmodifiable(builder.runAs);
    }

    public static PutRoleMappingRequest of(Function<Builder, ObjectBuilder<PutRoleMappingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final List<String> roles() {
        return this.roles;
    }

    @Nullable
    public final RoleMappingRule rules() {
        return this.rules;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.rules != null) {
            generator.writeKey("rules");
            this.rules.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutRoleMappingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::rules, RoleMappingRule._DESERIALIZER, "rules");
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutRoleMappingRequest> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Map<String, JsonData> metadata;
        private String name;
        @Nullable
        private Refresh refresh;
        @Nullable
        private List<String> roles;
        @Nullable
        private RoleMappingRule rules;
        @Nullable
        private List<String> runAs;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder rules(@Nullable RoleMappingRule value) {
            this.rules = value;
            return this;
        }

        public final Builder rules(Function<RoleMappingRule.Builder, ObjectBuilder<RoleMappingRule>> fn) {
            return this.rules(fn.apply(new RoleMappingRule.Builder()).build());
        }

        public final Builder runAs(List<String> list) {
            this.runAs = Builder._listAddAll(this.runAs, list);
            return this;
        }

        public final Builder runAs(String value, String ... values) {
            this.runAs = Builder._listAdd(this.runAs, value, values);
            return this;
        }

        @Override
        public PutRoleMappingRequest build() {
            this._checkSingleUse();
            return new PutRoleMappingRequest(this);
        }
    }
}

