/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.searchable_snapshots.MountResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MountRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> ignoreIndexSettings;
    private final String index;
    private final Map<String, JsonData> indexSettings;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String renamedIndex;
    private final String repository;
    private final String snapshot;
    @Nullable
    private final String storage;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<MountRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MountRequest::setupMountRequestDeserializer);
    public static final Endpoint<MountRequest, MountResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MountRequest, MountResponse>("es/searchable_snapshots.mount", request -> "POST", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_mount");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.storage != null) {
            params.put("storage", request.storage);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MountResponse._DESERIALIZER);

    private MountRequest(Builder builder) {
        this.ignoreIndexSettings = ApiTypeHelper.unmodifiable(builder.ignoreIndexSettings);
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.indexSettings = ApiTypeHelper.unmodifiable(builder.indexSettings);
        this.masterTimeout = builder.masterTimeout;
        this.renamedIndex = builder.renamedIndex;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.storage = builder.storage;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static MountRequest of(Function<Builder, ObjectBuilder<MountRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public final String index() {
        return this.index;
    }

    public final Map<String, JsonData> indexSettings() {
        return this.indexSettings;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String renamedIndex() {
        return this.renamedIndex;
    }

    public final String repository() {
        return this.repository;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final String storage() {
        return this.storage;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ignoreIndexSettings)) {
            generator.writeKey("ignore_index_settings");
            generator.writeStartArray();
            for (String string : this.ignoreIndexSettings) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.indexSettings)) {
            generator.writeKey("index_settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.indexSettings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.renamedIndex != null) {
            generator.writeKey("renamed_index");
            generator.write(this.renamedIndex);
        }
    }

    protected static void setupMountRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ignoreIndexSettings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_index_settings");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indexSettings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "index_settings");
        op.add(Builder::renamedIndex, JsonpDeserializer.stringDeserializer(), "renamed_index");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MountRequest> {
        @Nullable
        private List<String> ignoreIndexSettings;
        private String index;
        @Nullable
        private Map<String, JsonData> indexSettings;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String renamedIndex;
        private String repository;
        private String snapshot;
        @Nullable
        private String storage;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder ignoreIndexSettings(List<String> list) {
            this.ignoreIndexSettings = Builder._listAddAll(this.ignoreIndexSettings, list);
            return this;
        }

        public final Builder ignoreIndexSettings(String value, String ... values) {
            this.ignoreIndexSettings = Builder._listAdd(this.ignoreIndexSettings, value, values);
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder indexSettings(Map<String, JsonData> map) {
            this.indexSettings = Builder._mapPutAll(this.indexSettings, map);
            return this;
        }

        public final Builder indexSettings(String key, JsonData value) {
            this.indexSettings = Builder._mapPut(this.indexSettings, key, value);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder renamedIndex(@Nullable String value) {
            this.renamedIndex = value;
            return this;
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder storage(@Nullable String value) {
            this.storage = value;
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public MountRequest build() {
            this._checkSingleUse();
            return new MountRequest(this);
        }
    }
}

