/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.AnalysisConfig;
import co.elastic.clients.elasticsearch.ml.AnalysisLimits;
import co.elastic.clients.elasticsearch.ml.DataDescription;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.elasticsearch.ml.ValidateResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ValidateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final AnalysisConfig analysisConfig;
    @Nullable
    private final AnalysisLimits analysisLimits;
    @Nullable
    private final DataDescription dataDescription;
    @Nullable
    private final String description;
    @Nullable
    private final String jobId;
    @Nullable
    private final ModelPlotConfig modelPlot;
    @Nullable
    private final Long modelSnapshotRetentionDays;
    @Nullable
    private final String resultsIndexName;
    public static final JsonpDeserializer<ValidateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidateRequest::setupValidateRequestDeserializer);
    public static final Endpoint<ValidateRequest, ValidateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ValidateRequest, ValidateResponse>("es/ml.validate", request -> "POST", request -> "/_ml/anomaly_detectors/_validate", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ValidateResponse._DESERIALIZER);

    private ValidateRequest(Builder builder) {
        this.analysisConfig = builder.analysisConfig;
        this.analysisLimits = builder.analysisLimits;
        this.dataDescription = builder.dataDescription;
        this.description = builder.description;
        this.jobId = builder.jobId;
        this.modelPlot = builder.modelPlot;
        this.modelSnapshotRetentionDays = builder.modelSnapshotRetentionDays;
        this.resultsIndexName = builder.resultsIndexName;
    }

    public static ValidateRequest of(Function<Builder, ObjectBuilder<ValidateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AnalysisConfig analysisConfig() {
        return this.analysisConfig;
    }

    @Nullable
    public final AnalysisLimits analysisLimits() {
        return this.analysisLimits;
    }

    @Nullable
    public final DataDescription dataDescription() {
        return this.dataDescription;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final ModelPlotConfig modelPlot() {
        return this.modelPlot;
    }

    @Nullable
    public final Long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public final String resultsIndexName() {
        return this.resultsIndexName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analysisConfig != null) {
            generator.writeKey("analysis_config");
            this.analysisConfig.serialize(generator, mapper);
        }
        if (this.analysisLimits != null) {
            generator.writeKey("analysis_limits");
            this.analysisLimits.serialize(generator, mapper);
        }
        if (this.dataDescription != null) {
            generator.writeKey("data_description");
            this.dataDescription.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.jobId != null) {
            generator.writeKey("job_id");
            generator.write(this.jobId);
        }
        if (this.modelPlot != null) {
            generator.writeKey("model_plot");
            this.modelPlot.serialize(generator, mapper);
        }
        if (this.modelSnapshotRetentionDays != null) {
            generator.writeKey("model_snapshot_retention_days");
            generator.write(this.modelSnapshotRetentionDays.longValue());
        }
        if (this.resultsIndexName != null) {
            generator.writeKey("results_index_name");
            generator.write(this.resultsIndexName);
        }
    }

    protected static void setupValidateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analysisConfig, AnalysisConfig._DESERIALIZER, "analysis_config");
        op.add(Builder::analysisLimits, AnalysisLimits._DESERIALIZER, "analysis_limits");
        op.add(Builder::dataDescription, DataDescription._DESERIALIZER, "data_description");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::modelPlot, ModelPlotConfig._DESERIALIZER, "model_plot");
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days");
        op.add(Builder::resultsIndexName, JsonpDeserializer.stringDeserializer(), "results_index_name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ValidateRequest> {
        @Nullable
        private AnalysisConfig analysisConfig;
        @Nullable
        private AnalysisLimits analysisLimits;
        @Nullable
        private DataDescription dataDescription;
        @Nullable
        private String description;
        @Nullable
        private String jobId;
        @Nullable
        private ModelPlotConfig modelPlot;
        @Nullable
        private Long modelSnapshotRetentionDays;
        @Nullable
        private String resultsIndexName;

        public final Builder analysisConfig(@Nullable AnalysisConfig value) {
            this.analysisConfig = value;
            return this;
        }

        public final Builder analysisConfig(Function<AnalysisConfig.Builder, ObjectBuilder<AnalysisConfig>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfig.Builder()).build());
        }

        public final Builder analysisLimits(@Nullable AnalysisLimits value) {
            this.analysisLimits = value;
            return this;
        }

        public final Builder analysisLimits(Function<AnalysisLimits.Builder, ObjectBuilder<AnalysisLimits>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisLimits.Builder()).build());
        }

        public final Builder dataDescription(@Nullable DataDescription value) {
            this.dataDescription = value;
            return this;
        }

        public final Builder dataDescription(Function<DataDescription.Builder, ObjectBuilder<DataDescription>> fn) {
            return this.dataDescription(fn.apply(new DataDescription.Builder()).build());
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public final Builder modelPlot(@Nullable ModelPlotConfig value) {
            this.modelPlot = value;
            return this;
        }

        public final Builder modelPlot(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlot(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public final Builder modelSnapshotRetentionDays(@Nullable Long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public final Builder resultsIndexName(@Nullable String value) {
            this.resultsIndexName = value;
            return this;
        }

        @Override
        public ValidateRequest build() {
            this._checkSingleUse();
            return new ValidateRequest(this);
        }
    }
}

