/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PutFilterResponse
implements JsonpSerializable {
    private final String description;
    private final String filterId;
    private final List<String> items;
    public static final JsonpDeserializer<PutFilterResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutFilterResponse::setupPutFilterResponseDeserializer);

    private PutFilterResponse(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.filterId = ApiTypeHelper.requireNonNull(builder.filterId, this, "filterId");
        this.items = ApiTypeHelper.unmodifiableRequired(builder.items, (Object)this, "items");
    }

    public static PutFilterResponse of(Function<Builder, ObjectBuilder<PutFilterResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final List<String> items() {
        return this.items;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("filter_id");
        generator.write(this.filterId);
        if (ApiTypeHelper.isDefined(this.items)) {
            generator.writeKey("items");
            generator.writeStartArray();
            for (String item0 : this.items) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutFilterResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::filterId, JsonpDeserializer.stringDeserializer(), "filter_id");
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "items");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutFilterResponse> {
        private String description;
        private String filterId;
        private List<String> items;

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public final Builder items(List<String> list) {
            this.items = Builder._listAddAll(this.items, list);
            return this;
        }

        public final Builder items(String value, String ... values) {
            this.items = Builder._listAdd(this.items, value, values);
            return this;
        }

        @Override
        public PutFilterResponse build() {
            this._checkSingleUse();
            return new PutFilterResponse(this);
        }
    }
}

