/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InnerHitsResult
implements JsonpSerializable {
    private final HitsMetadata<JsonData> hits;
    public static final JsonpDeserializer<InnerHitsResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InnerHitsResult::setupInnerHitsResultDeserializer);

    private InnerHitsResult(Builder builder) {
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
    }

    public static InnerHitsResult of(Function<Builder, ObjectBuilder<InnerHitsResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final HitsMetadata<JsonData> hits() {
        return this.hits;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    protected static void setupInnerHitsResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(JsonData._DESERIALIZER), "hits");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<InnerHitsResult> {
        private HitsMetadata<JsonData> hits;

        public final Builder hits(HitsMetadata<JsonData> value) {
            this.hits = value;
            return this;
        }

        public final Builder hits(Function<HitsMetadata.Builder<JsonData>, ObjectBuilder<HitsMetadata<JsonData>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        @Override
        public InnerHitsResult build() {
            this._checkSingleUse();
            return new InnerHitsResult(this);
        }
    }
}

