/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlTrainedModelsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MlTrainedModelsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Integer from;
    @Nullable
    private final String modelId;
    @Nullable
    private final Integer size;
    public static final Endpoint<MlTrainedModelsRequest, MlTrainedModelsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlTrainedModelsRequest, MlTrainedModelsResponse>("es/cat.ml_trained_models", request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/trained_models");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlTrainedModelsResponse._DESERIALIZER);

    private MlTrainedModelsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
        this.from = builder.from;
        this.modelId = builder.modelId;
        this.size = builder.size;
    }

    public static MlTrainedModelsRequest of(Function<Builder, ObjectBuilder<MlTrainedModelsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlTrainedModelsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;
        @Nullable
        private Integer from;
        @Nullable
        private String modelId;
        @Nullable
        private Integer size;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public MlTrainedModelsRequest build() {
            this._checkSingleUse();
            return new MlTrainedModelsRequest(this);
        }
    }
}

