/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.BoostingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.CombinedFieldsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.CommonTermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ConstantScoreQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DisMaxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DistanceFeatureQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ExistsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.FuzzyQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoBoundingBoxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoDistanceQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoPolygonQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoShapeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.HasChildQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.HasParentQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IdsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchBoolPrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchNoneQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhrasePrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhraseQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MoreLikeThisQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MultiMatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ParentIdQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PercolateQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PinnedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RegexpQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ShapeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SimpleQueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanContainingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanFieldMaskingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanFirstQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanMultiTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanNearQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanNotQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanOrQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanWithinQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsSetQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TypeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WrapperQuery;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Query
implements TaggedUnion<Kind, Object>,
AggregationVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Query> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Query::setupQueryDeserializer, Builder::build);

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Filter;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Query(QueryVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._queryKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Query(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Query of(Function<Builder, ObjectBuilder<Query>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isBool() {
        return this._kind == Kind.Bool;
    }

    public BoolQuery bool() {
        return (BoolQuery)TaggedUnionUtils.get(this, Kind.Bool);
    }

    public boolean isBoosting() {
        return this._kind == Kind.Boosting;
    }

    public BoostingQuery boosting() {
        return (BoostingQuery)TaggedUnionUtils.get(this, Kind.Boosting);
    }

    public boolean isCommon() {
        return this._kind == Kind.Common;
    }

    public CommonTermsQuery common() {
        return (CommonTermsQuery)TaggedUnionUtils.get(this, Kind.Common);
    }

    public boolean isCombinedFields() {
        return this._kind == Kind.CombinedFields;
    }

    public CombinedFieldsQuery combinedFields() {
        return (CombinedFieldsQuery)TaggedUnionUtils.get(this, Kind.CombinedFields);
    }

    public boolean isConstantScore() {
        return this._kind == Kind.ConstantScore;
    }

    public ConstantScoreQuery constantScore() {
        return (ConstantScoreQuery)TaggedUnionUtils.get(this, Kind.ConstantScore);
    }

    public boolean isDisMax() {
        return this._kind == Kind.DisMax;
    }

    public DisMaxQuery disMax() {
        return (DisMaxQuery)TaggedUnionUtils.get(this, Kind.DisMax);
    }

    public boolean isDistanceFeature() {
        return this._kind == Kind.DistanceFeature;
    }

    public DistanceFeatureQuery distanceFeature() {
        return (DistanceFeatureQuery)TaggedUnionUtils.get(this, Kind.DistanceFeature);
    }

    public boolean isExists() {
        return this._kind == Kind.Exists;
    }

    public ExistsQuery exists() {
        return (ExistsQuery)TaggedUnionUtils.get(this, Kind.Exists);
    }

    public boolean isFunctionScore() {
        return this._kind == Kind.FunctionScore;
    }

    public FunctionScoreQuery functionScore() {
        return (FunctionScoreQuery)TaggedUnionUtils.get(this, Kind.FunctionScore);
    }

    public boolean isFuzzy() {
        return this._kind == Kind.Fuzzy;
    }

    public FuzzyQuery fuzzy() {
        return (FuzzyQuery)TaggedUnionUtils.get(this, Kind.Fuzzy);
    }

    public boolean isGeoBoundingBox() {
        return this._kind == Kind.GeoBoundingBox;
    }

    public GeoBoundingBoxQuery geoBoundingBox() {
        return (GeoBoundingBoxQuery)TaggedUnionUtils.get(this, Kind.GeoBoundingBox);
    }

    public boolean isGeoDistance() {
        return this._kind == Kind.GeoDistance;
    }

    public GeoDistanceQuery geoDistance() {
        return (GeoDistanceQuery)TaggedUnionUtils.get(this, Kind.GeoDistance);
    }

    public boolean isGeoPolygon() {
        return this._kind == Kind.GeoPolygon;
    }

    public GeoPolygonQuery geoPolygon() {
        return (GeoPolygonQuery)TaggedUnionUtils.get(this, Kind.GeoPolygon);
    }

    public boolean isGeoShape() {
        return this._kind == Kind.GeoShape;
    }

    public GeoShapeQuery geoShape() {
        return (GeoShapeQuery)TaggedUnionUtils.get(this, Kind.GeoShape);
    }

    public boolean isHasChild() {
        return this._kind == Kind.HasChild;
    }

    public HasChildQuery hasChild() {
        return (HasChildQuery)TaggedUnionUtils.get(this, Kind.HasChild);
    }

    public boolean isHasParent() {
        return this._kind == Kind.HasParent;
    }

    public HasParentQuery hasParent() {
        return (HasParentQuery)TaggedUnionUtils.get(this, Kind.HasParent);
    }

    public boolean isIds() {
        return this._kind == Kind.Ids;
    }

    public IdsQuery ids() {
        return (IdsQuery)TaggedUnionUtils.get(this, Kind.Ids);
    }

    public boolean isIntervals() {
        return this._kind == Kind.Intervals;
    }

    public IntervalsQuery intervals() {
        return (IntervalsQuery)TaggedUnionUtils.get(this, Kind.Intervals);
    }

    public boolean isMatch() {
        return this._kind == Kind.Match;
    }

    public MatchQuery match() {
        return (MatchQuery)TaggedUnionUtils.get(this, Kind.Match);
    }

    public boolean isMatchAll() {
        return this._kind == Kind.MatchAll;
    }

    public MatchAllQuery matchAll() {
        return (MatchAllQuery)TaggedUnionUtils.get(this, Kind.MatchAll);
    }

    public boolean isMatchBoolPrefix() {
        return this._kind == Kind.MatchBoolPrefix;
    }

    public MatchBoolPrefixQuery matchBoolPrefix() {
        return (MatchBoolPrefixQuery)TaggedUnionUtils.get(this, Kind.MatchBoolPrefix);
    }

    public boolean isMatchNone() {
        return this._kind == Kind.MatchNone;
    }

    public MatchNoneQuery matchNone() {
        return (MatchNoneQuery)TaggedUnionUtils.get(this, Kind.MatchNone);
    }

    public boolean isMatchPhrase() {
        return this._kind == Kind.MatchPhrase;
    }

    public MatchPhraseQuery matchPhrase() {
        return (MatchPhraseQuery)TaggedUnionUtils.get(this, Kind.MatchPhrase);
    }

    public boolean isMatchPhrasePrefix() {
        return this._kind == Kind.MatchPhrasePrefix;
    }

    public MatchPhrasePrefixQuery matchPhrasePrefix() {
        return (MatchPhrasePrefixQuery)TaggedUnionUtils.get(this, Kind.MatchPhrasePrefix);
    }

    public boolean isMoreLikeThis() {
        return this._kind == Kind.MoreLikeThis;
    }

    public MoreLikeThisQuery moreLikeThis() {
        return (MoreLikeThisQuery)TaggedUnionUtils.get(this, Kind.MoreLikeThis);
    }

    public boolean isMultiMatch() {
        return this._kind == Kind.MultiMatch;
    }

    public MultiMatchQuery multiMatch() {
        return (MultiMatchQuery)TaggedUnionUtils.get(this, Kind.MultiMatch);
    }

    public boolean isNested() {
        return this._kind == Kind.Nested;
    }

    public NestedQuery nested() {
        return (NestedQuery)TaggedUnionUtils.get(this, Kind.Nested);
    }

    public boolean isParentId() {
        return this._kind == Kind.ParentId;
    }

    public ParentIdQuery parentId() {
        return (ParentIdQuery)TaggedUnionUtils.get(this, Kind.ParentId);
    }

    public boolean isPercolate() {
        return this._kind == Kind.Percolate;
    }

    public PercolateQuery percolate() {
        return (PercolateQuery)TaggedUnionUtils.get(this, Kind.Percolate);
    }

    public boolean isPinned() {
        return this._kind == Kind.Pinned;
    }

    public PinnedQuery pinned() {
        return (PinnedQuery)TaggedUnionUtils.get(this, Kind.Pinned);
    }

    public boolean isPrefix() {
        return this._kind == Kind.Prefix;
    }

    public PrefixQuery prefix() {
        return (PrefixQuery)TaggedUnionUtils.get(this, Kind.Prefix);
    }

    public boolean isQueryString() {
        return this._kind == Kind.QueryString;
    }

    public QueryStringQuery queryString() {
        return (QueryStringQuery)TaggedUnionUtils.get(this, Kind.QueryString);
    }

    public boolean isRange() {
        return this._kind == Kind.Range;
    }

    public RangeQuery range() {
        return (RangeQuery)TaggedUnionUtils.get(this, Kind.Range);
    }

    public boolean isRankFeature() {
        return this._kind == Kind.RankFeature;
    }

    public RankFeatureQuery rankFeature() {
        return (RankFeatureQuery)TaggedUnionUtils.get(this, Kind.RankFeature);
    }

    public boolean isRegexp() {
        return this._kind == Kind.Regexp;
    }

    public RegexpQuery regexp() {
        return (RegexpQuery)TaggedUnionUtils.get(this, Kind.Regexp);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public ScriptQuery script() {
        return (ScriptQuery)TaggedUnionUtils.get(this, Kind.Script);
    }

    public boolean isScriptScore() {
        return this._kind == Kind.ScriptScore;
    }

    public ScriptScoreQuery scriptScore() {
        return (ScriptScoreQuery)TaggedUnionUtils.get(this, Kind.ScriptScore);
    }

    public boolean isShape() {
        return this._kind == Kind.Shape;
    }

    public ShapeQuery shape() {
        return (ShapeQuery)TaggedUnionUtils.get(this, Kind.Shape);
    }

    public boolean isSimpleQueryString() {
        return this._kind == Kind.SimpleQueryString;
    }

    public SimpleQueryStringQuery simpleQueryString() {
        return (SimpleQueryStringQuery)TaggedUnionUtils.get(this, Kind.SimpleQueryString);
    }

    public boolean isSpanContaining() {
        return this._kind == Kind.SpanContaining;
    }

    public SpanContainingQuery spanContaining() {
        return (SpanContainingQuery)TaggedUnionUtils.get(this, Kind.SpanContaining);
    }

    public boolean isFieldMaskingSpan() {
        return this._kind == Kind.FieldMaskingSpan;
    }

    public SpanFieldMaskingQuery fieldMaskingSpan() {
        return (SpanFieldMaskingQuery)TaggedUnionUtils.get(this, Kind.FieldMaskingSpan);
    }

    public boolean isSpanFirst() {
        return this._kind == Kind.SpanFirst;
    }

    public SpanFirstQuery spanFirst() {
        return (SpanFirstQuery)TaggedUnionUtils.get(this, Kind.SpanFirst);
    }

    public boolean isSpanMulti() {
        return this._kind == Kind.SpanMulti;
    }

    public SpanMultiTermQuery spanMulti() {
        return (SpanMultiTermQuery)TaggedUnionUtils.get(this, Kind.SpanMulti);
    }

    public boolean isSpanNear() {
        return this._kind == Kind.SpanNear;
    }

    public SpanNearQuery spanNear() {
        return (SpanNearQuery)TaggedUnionUtils.get(this, Kind.SpanNear);
    }

    public boolean isSpanNot() {
        return this._kind == Kind.SpanNot;
    }

    public SpanNotQuery spanNot() {
        return (SpanNotQuery)TaggedUnionUtils.get(this, Kind.SpanNot);
    }

    public boolean isSpanOr() {
        return this._kind == Kind.SpanOr;
    }

    public SpanOrQuery spanOr() {
        return (SpanOrQuery)TaggedUnionUtils.get(this, Kind.SpanOr);
    }

    public boolean isSpanTerm() {
        return this._kind == Kind.SpanTerm;
    }

    public SpanTermQuery spanTerm() {
        return (SpanTermQuery)TaggedUnionUtils.get(this, Kind.SpanTerm);
    }

    public boolean isSpanWithin() {
        return this._kind == Kind.SpanWithin;
    }

    public SpanWithinQuery spanWithin() {
        return (SpanWithinQuery)TaggedUnionUtils.get(this, Kind.SpanWithin);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermQuery term() {
        return (TermQuery)TaggedUnionUtils.get(this, Kind.Term);
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public TermsQuery terms() {
        return (TermsQuery)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isTermsSet() {
        return this._kind == Kind.TermsSet;
    }

    public TermsSetQuery termsSet() {
        return (TermsSetQuery)TaggedUnionUtils.get(this, Kind.TermsSet);
    }

    public boolean isWildcard() {
        return this._kind == Kind.Wildcard;
    }

    public WildcardQuery wildcard() {
        return (WildcardQuery)TaggedUnionUtils.get(this, Kind.Wildcard);
    }

    public boolean isWrapper() {
        return this._kind == Kind.Wrapper;
    }

    public WrapperQuery wrapper() {
        return (WrapperQuery)TaggedUnionUtils.get(this, Kind.Wrapper);
    }

    public boolean isType() {
        return this._kind == Kind.Type;
    }

    public TypeQuery type() {
        return (TypeQuery)TaggedUnionUtils.get(this, Kind.Type);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bool, BoolQuery._DESERIALIZER, "bool");
        op.add(Builder::boosting, BoostingQuery._DESERIALIZER, "boosting");
        op.add(Builder::common, CommonTermsQuery._DESERIALIZER, "common");
        op.add(Builder::combinedFields, CombinedFieldsQuery._DESERIALIZER, "combined_fields");
        op.add(Builder::constantScore, ConstantScoreQuery._DESERIALIZER, "constant_score");
        op.add(Builder::disMax, DisMaxQuery._DESERIALIZER, "dis_max");
        op.add(Builder::distanceFeature, DistanceFeatureQuery._DESERIALIZER, "distance_feature");
        op.add(Builder::exists, ExistsQuery._DESERIALIZER, "exists");
        op.add(Builder::functionScore, FunctionScoreQuery._DESERIALIZER, "function_score");
        op.add(Builder::fuzzy, FuzzyQuery._DESERIALIZER, "fuzzy");
        op.add(Builder::geoBoundingBox, GeoBoundingBoxQuery._DESERIALIZER, "geo_bounding_box");
        op.add(Builder::geoDistance, GeoDistanceQuery._DESERIALIZER, "geo_distance");
        op.add(Builder::geoPolygon, GeoPolygonQuery._DESERIALIZER, "geo_polygon");
        op.add(Builder::geoShape, GeoShapeQuery._DESERIALIZER, "geo_shape");
        op.add(Builder::hasChild, HasChildQuery._DESERIALIZER, "has_child");
        op.add(Builder::hasParent, HasParentQuery._DESERIALIZER, "has_parent");
        op.add(Builder::ids, IdsQuery._DESERIALIZER, "ids");
        op.add(Builder::intervals, IntervalsQuery._DESERIALIZER, "intervals");
        op.add(Builder::match, MatchQuery._DESERIALIZER, "match");
        op.add(Builder::matchAll, MatchAllQuery._DESERIALIZER, "match_all");
        op.add(Builder::matchBoolPrefix, MatchBoolPrefixQuery._DESERIALIZER, "match_bool_prefix");
        op.add(Builder::matchNone, MatchNoneQuery._DESERIALIZER, "match_none");
        op.add(Builder::matchPhrase, MatchPhraseQuery._DESERIALIZER, "match_phrase");
        op.add(Builder::matchPhrasePrefix, MatchPhrasePrefixQuery._DESERIALIZER, "match_phrase_prefix");
        op.add(Builder::moreLikeThis, MoreLikeThisQuery._DESERIALIZER, "more_like_this");
        op.add(Builder::multiMatch, MultiMatchQuery._DESERIALIZER, "multi_match");
        op.add(Builder::nested, NestedQuery._DESERIALIZER, "nested");
        op.add(Builder::parentId, ParentIdQuery._DESERIALIZER, "parent_id");
        op.add(Builder::percolate, PercolateQuery._DESERIALIZER, "percolate");
        op.add(Builder::pinned, PinnedQuery._DESERIALIZER, "pinned");
        op.add(Builder::prefix, PrefixQuery._DESERIALIZER, "prefix");
        op.add(Builder::queryString, QueryStringQuery._DESERIALIZER, "query_string");
        op.add(Builder::range, RangeQuery._DESERIALIZER, "range");
        op.add(Builder::rankFeature, RankFeatureQuery._DESERIALIZER, "rank_feature");
        op.add(Builder::regexp, RegexpQuery._DESERIALIZER, "regexp");
        op.add(Builder::script, ScriptQuery._DESERIALIZER, "script");
        op.add(Builder::scriptScore, ScriptScoreQuery._DESERIALIZER, "script_score");
        op.add(Builder::shape, ShapeQuery._DESERIALIZER, "shape");
        op.add(Builder::simpleQueryString, SimpleQueryStringQuery._DESERIALIZER, "simple_query_string");
        op.add(Builder::spanContaining, SpanContainingQuery._DESERIALIZER, "span_containing");
        op.add(Builder::fieldMaskingSpan, SpanFieldMaskingQuery._DESERIALIZER, "field_masking_span");
        op.add(Builder::spanFirst, SpanFirstQuery._DESERIALIZER, "span_first");
        op.add(Builder::spanMulti, SpanMultiTermQuery._DESERIALIZER, "span_multi");
        op.add(Builder::spanNear, SpanNearQuery._DESERIALIZER, "span_near");
        op.add(Builder::spanNot, SpanNotQuery._DESERIALIZER, "span_not");
        op.add(Builder::spanOr, SpanOrQuery._DESERIALIZER, "span_or");
        op.add(Builder::spanTerm, SpanTermQuery._DESERIALIZER, "span_term");
        op.add(Builder::spanWithin, SpanWithinQuery._DESERIALIZER, "span_within");
        op.add(Builder::term, TermQuery._DESERIALIZER, "term");
        op.add(Builder::terms, TermsQuery._DESERIALIZER, "terms");
        op.add(Builder::termsSet, TermsSetQuery._DESERIALIZER, "terms_set");
        op.add(Builder::wildcard, WildcardQuery._DESERIALIZER, "wildcard");
        op.add(Builder::wrapper, WrapperQuery._DESERIALIZER, "wrapper");
        op.add(Builder::type, TypeQuery._DESERIALIZER, "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Query> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Query> bool(BoolQuery v) {
            this._kind = Kind.Bool;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> bool(Function<BoolQuery.Builder, ObjectBuilder<BoolQuery>> fn) {
            return this.bool(fn.apply(new BoolQuery.Builder()).build());
        }

        public ObjectBuilder<Query> boosting(BoostingQuery v) {
            this._kind = Kind.Boosting;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> boosting(Function<BoostingQuery.Builder, ObjectBuilder<BoostingQuery>> fn) {
            return this.boosting(fn.apply(new BoostingQuery.Builder()).build());
        }

        public ObjectBuilder<Query> common(CommonTermsQuery v) {
            this._kind = Kind.Common;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> common(Function<CommonTermsQuery.Builder, ObjectBuilder<CommonTermsQuery>> fn) {
            return this.common(fn.apply(new CommonTermsQuery.Builder()).build());
        }

        public ObjectBuilder<Query> combinedFields(CombinedFieldsQuery v) {
            this._kind = Kind.CombinedFields;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> combinedFields(Function<CombinedFieldsQuery.Builder, ObjectBuilder<CombinedFieldsQuery>> fn) {
            return this.combinedFields(fn.apply(new CombinedFieldsQuery.Builder()).build());
        }

        public ObjectBuilder<Query> constantScore(ConstantScoreQuery v) {
            this._kind = Kind.ConstantScore;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> constantScore(Function<ConstantScoreQuery.Builder, ObjectBuilder<ConstantScoreQuery>> fn) {
            return this.constantScore(fn.apply(new ConstantScoreQuery.Builder()).build());
        }

        public ObjectBuilder<Query> disMax(DisMaxQuery v) {
            this._kind = Kind.DisMax;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> disMax(Function<DisMaxQuery.Builder, ObjectBuilder<DisMaxQuery>> fn) {
            return this.disMax(fn.apply(new DisMaxQuery.Builder()).build());
        }

        public ObjectBuilder<Query> distanceFeature(DistanceFeatureQuery v) {
            this._kind = Kind.DistanceFeature;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> distanceFeature(Function<DistanceFeatureQuery.Builder, ObjectBuilder<DistanceFeatureQuery>> fn) {
            return this.distanceFeature(fn.apply(new DistanceFeatureQuery.Builder()).build());
        }

        public ObjectBuilder<Query> exists(ExistsQuery v) {
            this._kind = Kind.Exists;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> exists(Function<ExistsQuery.Builder, ObjectBuilder<ExistsQuery>> fn) {
            return this.exists(fn.apply(new ExistsQuery.Builder()).build());
        }

        public ObjectBuilder<Query> functionScore(FunctionScoreQuery v) {
            this._kind = Kind.FunctionScore;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> functionScore(Function<FunctionScoreQuery.Builder, ObjectBuilder<FunctionScoreQuery>> fn) {
            return this.functionScore(fn.apply(new FunctionScoreQuery.Builder()).build());
        }

        public ObjectBuilder<Query> fuzzy(FuzzyQuery v) {
            this._kind = Kind.Fuzzy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> fuzzy(Function<FuzzyQuery.Builder, ObjectBuilder<FuzzyQuery>> fn) {
            return this.fuzzy(fn.apply(new FuzzyQuery.Builder()).build());
        }

        public ObjectBuilder<Query> geoBoundingBox(GeoBoundingBoxQuery v) {
            this._kind = Kind.GeoBoundingBox;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> geoBoundingBox(Function<GeoBoundingBoxQuery.Builder, ObjectBuilder<GeoBoundingBoxQuery>> fn) {
            return this.geoBoundingBox(fn.apply(new GeoBoundingBoxQuery.Builder()).build());
        }

        public ObjectBuilder<Query> geoDistance(GeoDistanceQuery v) {
            this._kind = Kind.GeoDistance;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> geoDistance(Function<GeoDistanceQuery.Builder, ObjectBuilder<GeoDistanceQuery>> fn) {
            return this.geoDistance(fn.apply(new GeoDistanceQuery.Builder()).build());
        }

        public ObjectBuilder<Query> geoPolygon(GeoPolygonQuery v) {
            this._kind = Kind.GeoPolygon;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> geoPolygon(Function<GeoPolygonQuery.Builder, ObjectBuilder<GeoPolygonQuery>> fn) {
            return this.geoPolygon(fn.apply(new GeoPolygonQuery.Builder()).build());
        }

        public ObjectBuilder<Query> geoShape(GeoShapeQuery v) {
            this._kind = Kind.GeoShape;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> geoShape(Function<GeoShapeQuery.Builder, ObjectBuilder<GeoShapeQuery>> fn) {
            return this.geoShape(fn.apply(new GeoShapeQuery.Builder()).build());
        }

        public ObjectBuilder<Query> hasChild(HasChildQuery v) {
            this._kind = Kind.HasChild;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> hasChild(Function<HasChildQuery.Builder, ObjectBuilder<HasChildQuery>> fn) {
            return this.hasChild(fn.apply(new HasChildQuery.Builder()).build());
        }

        public ObjectBuilder<Query> hasParent(HasParentQuery v) {
            this._kind = Kind.HasParent;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> hasParent(Function<HasParentQuery.Builder, ObjectBuilder<HasParentQuery>> fn) {
            return this.hasParent(fn.apply(new HasParentQuery.Builder()).build());
        }

        public ObjectBuilder<Query> ids(IdsQuery v) {
            this._kind = Kind.Ids;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> ids(Function<IdsQuery.Builder, ObjectBuilder<IdsQuery>> fn) {
            return this.ids(fn.apply(new IdsQuery.Builder()).build());
        }

        public ObjectBuilder<Query> intervals(IntervalsQuery v) {
            this._kind = Kind.Intervals;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> intervals(Function<IntervalsQuery.Builder, ObjectBuilder<IntervalsQuery>> fn) {
            return this.intervals(fn.apply(new IntervalsQuery.Builder()).build());
        }

        public ObjectBuilder<Query> match(MatchQuery v) {
            this._kind = Kind.Match;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> match(Function<MatchQuery.Builder, ObjectBuilder<MatchQuery>> fn) {
            return this.match(fn.apply(new MatchQuery.Builder()).build());
        }

        public ObjectBuilder<Query> matchAll(MatchAllQuery v) {
            this._kind = Kind.MatchAll;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> matchAll(Function<MatchAllQuery.Builder, ObjectBuilder<MatchAllQuery>> fn) {
            return this.matchAll(fn.apply(new MatchAllQuery.Builder()).build());
        }

        public ObjectBuilder<Query> matchBoolPrefix(MatchBoolPrefixQuery v) {
            this._kind = Kind.MatchBoolPrefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> matchBoolPrefix(Function<MatchBoolPrefixQuery.Builder, ObjectBuilder<MatchBoolPrefixQuery>> fn) {
            return this.matchBoolPrefix(fn.apply(new MatchBoolPrefixQuery.Builder()).build());
        }

        public ObjectBuilder<Query> matchNone(MatchNoneQuery v) {
            this._kind = Kind.MatchNone;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> matchNone(Function<MatchNoneQuery.Builder, ObjectBuilder<MatchNoneQuery>> fn) {
            return this.matchNone(fn.apply(new MatchNoneQuery.Builder()).build());
        }

        public ObjectBuilder<Query> matchPhrase(MatchPhraseQuery v) {
            this._kind = Kind.MatchPhrase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> matchPhrase(Function<MatchPhraseQuery.Builder, ObjectBuilder<MatchPhraseQuery>> fn) {
            return this.matchPhrase(fn.apply(new MatchPhraseQuery.Builder()).build());
        }

        public ObjectBuilder<Query> matchPhrasePrefix(MatchPhrasePrefixQuery v) {
            this._kind = Kind.MatchPhrasePrefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> matchPhrasePrefix(Function<MatchPhrasePrefixQuery.Builder, ObjectBuilder<MatchPhrasePrefixQuery>> fn) {
            return this.matchPhrasePrefix(fn.apply(new MatchPhrasePrefixQuery.Builder()).build());
        }

        public ObjectBuilder<Query> moreLikeThis(MoreLikeThisQuery v) {
            this._kind = Kind.MoreLikeThis;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> moreLikeThis(Function<MoreLikeThisQuery.Builder, ObjectBuilder<MoreLikeThisQuery>> fn) {
            return this.moreLikeThis(fn.apply(new MoreLikeThisQuery.Builder()).build());
        }

        public ObjectBuilder<Query> multiMatch(MultiMatchQuery v) {
            this._kind = Kind.MultiMatch;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> multiMatch(Function<MultiMatchQuery.Builder, ObjectBuilder<MultiMatchQuery>> fn) {
            return this.multiMatch(fn.apply(new MultiMatchQuery.Builder()).build());
        }

        public ObjectBuilder<Query> nested(NestedQuery v) {
            this._kind = Kind.Nested;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> nested(Function<NestedQuery.Builder, ObjectBuilder<NestedQuery>> fn) {
            return this.nested(fn.apply(new NestedQuery.Builder()).build());
        }

        public ObjectBuilder<Query> parentId(ParentIdQuery v) {
            this._kind = Kind.ParentId;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> parentId(Function<ParentIdQuery.Builder, ObjectBuilder<ParentIdQuery>> fn) {
            return this.parentId(fn.apply(new ParentIdQuery.Builder()).build());
        }

        public ObjectBuilder<Query> percolate(PercolateQuery v) {
            this._kind = Kind.Percolate;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> percolate(Function<PercolateQuery.Builder, ObjectBuilder<PercolateQuery>> fn) {
            return this.percolate(fn.apply(new PercolateQuery.Builder()).build());
        }

        public ObjectBuilder<Query> pinned(PinnedQuery v) {
            this._kind = Kind.Pinned;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> pinned(Function<PinnedQuery.Builder, ObjectBuilder<PinnedQuery>> fn) {
            return this.pinned(fn.apply(new PinnedQuery.Builder()).build());
        }

        public ObjectBuilder<Query> prefix(PrefixQuery v) {
            this._kind = Kind.Prefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> prefix(Function<PrefixQuery.Builder, ObjectBuilder<PrefixQuery>> fn) {
            return this.prefix(fn.apply(new PrefixQuery.Builder()).build());
        }

        public ObjectBuilder<Query> queryString(QueryStringQuery v) {
            this._kind = Kind.QueryString;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> queryString(Function<QueryStringQuery.Builder, ObjectBuilder<QueryStringQuery>> fn) {
            return this.queryString(fn.apply(new QueryStringQuery.Builder()).build());
        }

        public ObjectBuilder<Query> range(RangeQuery v) {
            this._kind = Kind.Range;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> range(Function<RangeQuery.Builder, ObjectBuilder<RangeQuery>> fn) {
            return this.range(fn.apply(new RangeQuery.Builder()).build());
        }

        public ObjectBuilder<Query> rankFeature(RankFeatureQuery v) {
            this._kind = Kind.RankFeature;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> rankFeature(Function<RankFeatureQuery.Builder, ObjectBuilder<RankFeatureQuery>> fn) {
            return this.rankFeature(fn.apply(new RankFeatureQuery.Builder()).build());
        }

        public ObjectBuilder<Query> regexp(RegexpQuery v) {
            this._kind = Kind.Regexp;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> regexp(Function<RegexpQuery.Builder, ObjectBuilder<RegexpQuery>> fn) {
            return this.regexp(fn.apply(new RegexpQuery.Builder()).build());
        }

        public ObjectBuilder<Query> script(ScriptQuery v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> script(Function<ScriptQuery.Builder, ObjectBuilder<ScriptQuery>> fn) {
            return this.script(fn.apply(new ScriptQuery.Builder()).build());
        }

        public ObjectBuilder<Query> scriptScore(ScriptScoreQuery v) {
            this._kind = Kind.ScriptScore;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> scriptScore(Function<ScriptScoreQuery.Builder, ObjectBuilder<ScriptScoreQuery>> fn) {
            return this.scriptScore(fn.apply(new ScriptScoreQuery.Builder()).build());
        }

        public ObjectBuilder<Query> shape(ShapeQuery v) {
            this._kind = Kind.Shape;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> shape(Function<ShapeQuery.Builder, ObjectBuilder<ShapeQuery>> fn) {
            return this.shape(fn.apply(new ShapeQuery.Builder()).build());
        }

        public ObjectBuilder<Query> simpleQueryString(SimpleQueryStringQuery v) {
            this._kind = Kind.SimpleQueryString;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> simpleQueryString(Function<SimpleQueryStringQuery.Builder, ObjectBuilder<SimpleQueryStringQuery>> fn) {
            return this.simpleQueryString(fn.apply(new SimpleQueryStringQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanContaining(SpanContainingQuery v) {
            this._kind = Kind.SpanContaining;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanContaining(Function<SpanContainingQuery.Builder, ObjectBuilder<SpanContainingQuery>> fn) {
            return this.spanContaining(fn.apply(new SpanContainingQuery.Builder()).build());
        }

        public ObjectBuilder<Query> fieldMaskingSpan(SpanFieldMaskingQuery v) {
            this._kind = Kind.FieldMaskingSpan;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> fieldMaskingSpan(Function<SpanFieldMaskingQuery.Builder, ObjectBuilder<SpanFieldMaskingQuery>> fn) {
            return this.fieldMaskingSpan(fn.apply(new SpanFieldMaskingQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanFirst(SpanFirstQuery v) {
            this._kind = Kind.SpanFirst;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanFirst(Function<SpanFirstQuery.Builder, ObjectBuilder<SpanFirstQuery>> fn) {
            return this.spanFirst(fn.apply(new SpanFirstQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanMulti(SpanMultiTermQuery v) {
            this._kind = Kind.SpanMulti;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanMulti(Function<SpanMultiTermQuery.Builder, ObjectBuilder<SpanMultiTermQuery>> fn) {
            return this.spanMulti(fn.apply(new SpanMultiTermQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanNear(SpanNearQuery v) {
            this._kind = Kind.SpanNear;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanNear(Function<SpanNearQuery.Builder, ObjectBuilder<SpanNearQuery>> fn) {
            return this.spanNear(fn.apply(new SpanNearQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanNot(SpanNotQuery v) {
            this._kind = Kind.SpanNot;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanNot(Function<SpanNotQuery.Builder, ObjectBuilder<SpanNotQuery>> fn) {
            return this.spanNot(fn.apply(new SpanNotQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanOr(SpanOrQuery v) {
            this._kind = Kind.SpanOr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanOr(Function<SpanOrQuery.Builder, ObjectBuilder<SpanOrQuery>> fn) {
            return this.spanOr(fn.apply(new SpanOrQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanTerm(SpanTermQuery v) {
            this._kind = Kind.SpanTerm;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanTerm(Function<SpanTermQuery.Builder, ObjectBuilder<SpanTermQuery>> fn) {
            return this.spanTerm(fn.apply(new SpanTermQuery.Builder()).build());
        }

        public ObjectBuilder<Query> spanWithin(SpanWithinQuery v) {
            this._kind = Kind.SpanWithin;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> spanWithin(Function<SpanWithinQuery.Builder, ObjectBuilder<SpanWithinQuery>> fn) {
            return this.spanWithin(fn.apply(new SpanWithinQuery.Builder()).build());
        }

        public ObjectBuilder<Query> term(TermQuery v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> term(Function<TermQuery.Builder, ObjectBuilder<TermQuery>> fn) {
            return this.term(fn.apply(new TermQuery.Builder()).build());
        }

        public ObjectBuilder<Query> terms(TermsQuery v) {
            this._kind = Kind.Terms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> terms(Function<TermsQuery.Builder, ObjectBuilder<TermsQuery>> fn) {
            return this.terms(fn.apply(new TermsQuery.Builder()).build());
        }

        public ObjectBuilder<Query> termsSet(TermsSetQuery v) {
            this._kind = Kind.TermsSet;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> termsSet(Function<TermsSetQuery.Builder, ObjectBuilder<TermsSetQuery>> fn) {
            return this.termsSet(fn.apply(new TermsSetQuery.Builder()).build());
        }

        public ObjectBuilder<Query> wildcard(WildcardQuery v) {
            this._kind = Kind.Wildcard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> wildcard(Function<WildcardQuery.Builder, ObjectBuilder<WildcardQuery>> fn) {
            return this.wildcard(fn.apply(new WildcardQuery.Builder()).build());
        }

        public ObjectBuilder<Query> wrapper(WrapperQuery v) {
            this._kind = Kind.Wrapper;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> wrapper(Function<WrapperQuery.Builder, ObjectBuilder<WrapperQuery>> fn) {
            return this.wrapper(fn.apply(new WrapperQuery.Builder()).build());
        }

        public ObjectBuilder<Query> type(TypeQuery v) {
            this._kind = Kind.Type;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Query> type(Function<TypeQuery.Builder, ObjectBuilder<TypeQuery>> fn) {
            return this.type(fn.apply(new TypeQuery.Builder()).build());
        }

        @Override
        public Query build() {
            this._checkSingleUse();
            return new Query(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Bool("bool"),
        Boosting("boosting"),
        Common("common"),
        CombinedFields("combined_fields"),
        ConstantScore("constant_score"),
        DisMax("dis_max"),
        DistanceFeature("distance_feature"),
        Exists("exists"),
        FunctionScore("function_score"),
        Fuzzy("fuzzy"),
        GeoBoundingBox("geo_bounding_box"),
        GeoDistance("geo_distance"),
        GeoPolygon("geo_polygon"),
        GeoShape("geo_shape"),
        HasChild("has_child"),
        HasParent("has_parent"),
        Ids("ids"),
        Intervals("intervals"),
        Match("match"),
        MatchAll("match_all"),
        MatchBoolPrefix("match_bool_prefix"),
        MatchNone("match_none"),
        MatchPhrase("match_phrase"),
        MatchPhrasePrefix("match_phrase_prefix"),
        MoreLikeThis("more_like_this"),
        MultiMatch("multi_match"),
        Nested("nested"),
        ParentId("parent_id"),
        Percolate("percolate"),
        Pinned("pinned"),
        Prefix("prefix"),
        QueryString("query_string"),
        Range("range"),
        RankFeature("rank_feature"),
        Regexp("regexp"),
        Script("script"),
        ScriptScore("script_score"),
        Shape("shape"),
        SimpleQueryString("simple_query_string"),
        SpanContaining("span_containing"),
        FieldMaskingSpan("field_masking_span"),
        SpanFirst("span_first"),
        SpanMulti("span_multi"),
        SpanNear("span_near"),
        SpanNot("span_not"),
        SpanOr("span_or"),
        SpanTerm("span_term"),
        SpanWithin("span_within"),
        Term("term"),
        Terms("terms"),
        TermsSet("terms_set"),
        Wildcard("wildcard"),
        Wrapper("wrapper"),
        Type("type");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

