/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.Analyzer;
import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.Language;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LanguageAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    @Nullable
    private final String version;
    private final Language language;
    private final List<String> stemExclusion;
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    public static final JsonpDeserializer<LanguageAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LanguageAnalyzer::setupLanguageAnalyzerDeserializer);

    private LanguageAnalyzer(Builder builder) {
        this.version = builder.version;
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
        this.stemExclusion = ApiTypeHelper.unmodifiableRequired(builder.stemExclusion, (Object)this, "stemExclusion");
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
        this.stopwordsPath = builder.stopwordsPath;
    }

    public static LanguageAnalyzer of(Function<Builder, ObjectBuilder<LanguageAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Language;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    public final Language language() {
        return this.language;
    }

    public final List<String> stemExclusion() {
        return this.stemExclusion;
    }

    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "language");
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.stemExclusion)) {
            generator.writeKey("stem_exclusion");
            generator.writeStartArray();
            for (String item0 : this.stemExclusion) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
    }

    protected static void setupLanguageAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::language, Language._DESERIALIZER, "language");
        op.add(Builder::stemExclusion, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stem_exclusion");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<LanguageAnalyzer> {
        @Nullable
        private String version;
        private Language language;
        private List<String> stemExclusion;
        @Nullable
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder language(Language value) {
            this.language = value;
            return this;
        }

        public final Builder stemExclusion(List<String> list) {
            this.stemExclusion = Builder._listAddAll(this.stemExclusion, list);
            return this;
        }

        public final Builder stemExclusion(String value, String ... values) {
            this.stemExclusion = Builder._listAdd(this.stemExclusion, value, values);
            return this;
        }

        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        public final Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        public LanguageAnalyzer build() {
            this._checkSingleUse();
            return new LanguageAnalyzer(this);
        }
    }
}

