/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.GeoShapeRelation;
import org.opensearch.client.opensearch._types.query_dsl.FieldLookup;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GeoShapeFieldQuery
implements PlainJsonSerializable {
    @Nullable
    private final JsonData shape;
    @Nullable
    private final FieldLookup indexedShape;
    @Nullable
    private final GeoShapeRelation relation;
    public static final JsonpDeserializer<GeoShapeFieldQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoShapeFieldQuery::setupGeoShapeFieldQueryDeserializer);

    private GeoShapeFieldQuery(Builder builder) {
        this.shape = builder.shape;
        this.indexedShape = builder.indexedShape;
        this.relation = builder.relation;
    }

    public static GeoShapeFieldQuery of(Function<Builder, ObjectBuilder<GeoShapeFieldQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final JsonData shape() {
        return this.shape;
    }

    @Nullable
    public final FieldLookup indexedShape() {
        return this.indexedShape;
    }

    @Nullable
    public final GeoShapeRelation relation() {
        return this.relation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.shape != null) {
            generator.writeKey("shape");
            this.shape.serialize(generator, mapper);
        }
        if (this.indexedShape != null) {
            generator.writeKey("indexed_shape");
            this.indexedShape.serialize(generator, mapper);
        }
        if (this.relation != null) {
            generator.writeKey("relation");
            this.relation.serialize(generator, mapper);
        }
    }

    public Builder toBuilder() {
        return new Builder().shape(this.shape).indexedShape(this.indexedShape).relation(this.relation);
    }

    protected static void setupGeoShapeFieldQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shape, JsonData._DESERIALIZER, "shape");
        op.add(Builder::indexedShape, FieldLookup._DESERIALIZER, "indexed_shape");
        op.add(Builder::relation, GeoShapeRelation._DESERIALIZER, "relation");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoShapeFieldQuery> {
        @Nullable
        private JsonData shape;
        @Nullable
        private FieldLookup indexedShape;
        @Nullable
        private GeoShapeRelation relation;

        public final Builder shape(@Nullable JsonData value) {
            this.shape = value;
            return this;
        }

        public final Builder indexedShape(@Nullable FieldLookup value) {
            this.indexedShape = value;
            return this;
        }

        public final Builder indexedShape(Function<FieldLookup.Builder, ObjectBuilder<FieldLookup>> fn) {
            return this.indexedShape(fn.apply(new FieldLookup.Builder()).build());
        }

        public final Builder relation(@Nullable GeoShapeRelation value) {
            this.relation = value;
            return this;
        }

        @Override
        public GeoShapeFieldQuery build() {
            this._checkSingleUse();
            return new GeoShapeFieldQuery(this);
        }
    }
}

