/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class WriteResponseBase
implements PlainJsonSerializable {
    @Nullable
    private final Boolean forcedRefresh;
    @Nonnull
    private final String id;
    @Nonnull
    private final String index;
    private final long primaryTerm;
    @Nonnull
    private final Result result;
    private final long seqNo;
    @Nonnull
    private final ShardStatistics shards;
    private final long version;

    protected WriteResponseBase(AbstractBuilder<?> builder) {
        this.forcedRefresh = ((AbstractBuilder)builder).forcedRefresh;
        this.id = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).index, this, "index");
        this.primaryTerm = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).primaryTerm, this, "primaryTerm");
        this.result = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).result, this, "result");
        this.seqNo = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).seqNo, this, "seqNo");
        this.shards = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).shards, this, "shards");
        this.version = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).version, this, "version");
    }

    @Nullable
    public final Boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    public final long primaryTerm() {
        return this.primaryTerm;
    }

    @Nonnull
    public final Result result() {
        return this.result;
    }

    public final long seqNo() {
        return this.seqNo;
    }

    @Nonnull
    public final ShardStatistics shards() {
        return this.shards;
    }

    public final long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.forcedRefresh != null) {
            generator.writeKey("forced_refresh");
            generator.write(this.forcedRefresh.booleanValue());
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
        generator.writeKey("_seq_no");
        generator.write(this.seqNo);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("_version");
        generator.write(this.version);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWriteResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::forcedRefresh, JsonpDeserializer.booleanDeserializer(), "forced_refresh");
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(AbstractBuilder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(AbstractBuilder::result, Result._DESERIALIZER, "result");
        op.add(AbstractBuilder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.forcedRefresh);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Long.hashCode(this.primaryTerm);
        result = 31 * result + this.result.hashCode();
        result = 31 * result + Long.hashCode(this.seqNo);
        result = 31 * result + this.shards.hashCode();
        result = 31 * result + Long.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteResponseBase other = (WriteResponseBase)o;
        return Objects.equals(this.forcedRefresh, other.forcedRefresh) && this.id.equals(other.id) && this.index.equals(other.index) && this.primaryTerm == other.primaryTerm && this.result.equals(other.result) && this.seqNo == other.seqNo && this.shards.equals(other.shards) && this.version == other.version;
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private Boolean forcedRefresh;
        private String id;
        private String index;
        private Long primaryTerm;
        private Result result;
        private Long seqNo;
        private ShardStatistics shards;
        private Long version;

        protected AbstractBuilder() {
        }

        public final BuilderT forcedRefresh(@Nullable Boolean value) {
            this.forcedRefresh = value;
            return this.self();
        }

        public final BuilderT id(String value) {
            this.id = value;
            return this.self();
        }

        public final BuilderT index(String value) {
            this.index = value;
            return this.self();
        }

        public final BuilderT primaryTerm(long value) {
            this.primaryTerm = value;
            return this.self();
        }

        public final BuilderT result(Result value) {
            this.result = value;
            return this.self();
        }

        public final BuilderT seqNo(long value) {
            this.seqNo = value;
            return this.self();
        }

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final BuilderT version(long value) {
            this.version = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

