/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.sqs;

import java.util.Objects;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.sqs.AwsAuthenticationAdapter;
import org.opensearch.dataprepper.plugins.source.sqs.SqsService;
import org.opensearch.dataprepper.plugins.source.sqs.SqsSourceConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@DataPrepperPlugin(name="sqs", pluginType=Source.class, pluginConfigurationType=SqsSourceConfig.class)
public class SqsSource
implements Source<Record<Event>> {
    private final PluginMetrics pluginMetrics;
    private final PluginFactory pluginFactory;
    private final SqsSourceConfig sqsSourceConfig;
    private SqsService sqsService;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private final boolean acknowledgementsEnabled;

    @DataPrepperPluginConstructor
    public SqsSource(PluginMetrics pluginMetrics, SqsSourceConfig sqsSourceConfig, PluginFactory pluginFactory, AcknowledgementSetManager acknowledgementSetManager, AwsCredentialsSupplier awsCredentialsSupplier) {
        this.pluginMetrics = pluginMetrics;
        this.pluginFactory = pluginFactory;
        this.sqsSourceConfig = sqsSourceConfig;
        this.acknowledgementsEnabled = sqsSourceConfig.getAcknowledgements();
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
    }

    public void start(Buffer<Record<Event>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer is null");
        }
        AwsAuthenticationAdapter awsAuthenticationAdapter = new AwsAuthenticationAdapter(this.awsCredentialsSupplier, this.sqsSourceConfig);
        AwsCredentialsProvider credentialsProvider = awsAuthenticationAdapter.getCredentialsProvider();
        this.sqsService = new SqsService(buffer, this.acknowledgementSetManager, this.sqsSourceConfig, this.pluginMetrics, this.pluginFactory, credentialsProvider);
        this.sqsService.start();
    }

    public boolean areAcknowledgementsEnabled() {
        return this.acknowledgementsEnabled;
    }

    public void stop() {
        if (Objects.nonNull(this.sqsService)) {
            this.sqsService.stop();
        }
    }
}

