/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
@ThreadSafe
public final class Page<T> {
    private final List<T> items;
    private final Map<String, AttributeValue> lastEvaluatedKey;
    private final Integer count;
    private final Integer scannedCount;
    private final ConsumedCapacity consumedCapacity;

    private Page(List<T> items, Map<String, AttributeValue> lastEvaluatedKey) {
        this.items = items;
        this.lastEvaluatedKey = lastEvaluatedKey;
        this.count = null;
        this.scannedCount = null;
        this.consumedCapacity = null;
    }

    private Page(Builder<T> builder) {
        this.items = ((Builder)builder).items;
        this.lastEvaluatedKey = ((Builder)builder).lastEvaluatedKey;
        this.count = ((Builder)builder).count;
        this.scannedCount = ((Builder)builder).scannedCount;
        this.consumedCapacity = ((Builder)builder).consumedCapacity;
    }

    @Deprecated
    public static <T> Page<T> create(List<T> items, Map<String, AttributeValue> lastEvaluatedKey) {
        return new Page<T>(items, lastEvaluatedKey);
    }

    @Deprecated
    public static <T> Page<T> create(List<T> items) {
        return new Page<T>(items, null);
    }

    public List<T> items() {
        return this.items;
    }

    public Map<String, AttributeValue> lastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public Integer count() {
        return this.count;
    }

    public Integer scannedCount() {
        return this.scannedCount;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        if (this.items != null ? !this.items.equals(page.items) : page.items != null) {
            return false;
        }
        if (this.lastEvaluatedKey != null ? !this.lastEvaluatedKey.equals(page.lastEvaluatedKey) : page.lastEvaluatedKey != null) {
            return false;
        }
        if (this.consumedCapacity != null ? !this.consumedCapacity.equals((Object)page.consumedCapacity) : page.consumedCapacity != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(page.count) : page.count != null) {
            return false;
        }
        return this.scannedCount != null ? this.scannedCount.equals(page.scannedCount) : page.scannedCount == null;
    }

    public int hashCode() {
        int result = this.items != null ? this.items.hashCode() : 0;
        result = 31 * result + (this.lastEvaluatedKey != null ? this.lastEvaluatedKey.hashCode() : 0);
        result = 31 * result + (this.consumedCapacity != null ? this.consumedCapacity.hashCode() : 0);
        result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
        result = 31 * result + (this.scannedCount != null ? this.scannedCount.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"Page").add("lastEvaluatedKey", this.lastEvaluatedKey).add("items", this.items).build();
    }

    public static <T> Builder<T> builder(Class<T> itemClass) {
        return new Builder();
    }

    public static final class Builder<T> {
        private List<T> items;
        private Map<String, AttributeValue> lastEvaluatedKey;
        private Integer count;
        private Integer scannedCount;
        private ConsumedCapacity consumedCapacity;

        public Builder<T> items(List<T> items) {
            this.items = new ArrayList<T>(items);
            return this;
        }

        public Builder<T> lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = new HashMap<String, AttributeValue>(lastEvaluatedKey);
            return this;
        }

        public Builder<T> count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder<T> scannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
            return this;
        }

        public Builder<T> consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public Page<T> build() {
            return new Page(this);
        }
    }
}

