/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.extensions.annotations.DynamoDbAtomicCounter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTags;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondaryPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondarySortKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSortKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbUpdateBehavior;

@SdkInternalApi
public final class BeanTableSchemaAttributeTags {
    private BeanTableSchemaAttributeTags() {
    }

    public static StaticAttributeTag attributeTagFor(DynamoDbPartitionKey annotation) {
        return StaticAttributeTags.primaryPartitionKey();
    }

    public static StaticAttributeTag attributeTagFor(DynamoDbSortKey annotation) {
        return StaticAttributeTags.primarySortKey();
    }

    public static StaticAttributeTag attributeTagFor(DynamoDbSecondaryPartitionKey annotation) {
        return StaticAttributeTags.secondaryPartitionKey(Arrays.asList(annotation.indexNames()));
    }

    public static StaticAttributeTag attributeTagFor(DynamoDbSecondarySortKey annotation) {
        return StaticAttributeTags.secondarySortKey(Arrays.asList(annotation.indexNames()));
    }

    public static StaticAttributeTag attributeTagFor(DynamoDbUpdateBehavior annotation) {
        return StaticAttributeTags.updateBehavior(annotation.value());
    }

    public static StaticAttributeTag attributeTagFor(DynamoDbAtomicCounter annotation) {
        return StaticAttributeTags.atomicCounter(annotation.delta(), annotation.startValue());
    }
}

