/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Document;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.DefaultDynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.ExtensionResolver;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.BatchGetItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.BatchWriteItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactGetItemsOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactWriteItemsOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchGetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchGetResultPageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteResult;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactGetItemsEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactWriteItemsEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactWriteItemsEnhancedResponse;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public final class DefaultDynamoDbEnhancedClient
implements DynamoDbEnhancedClient {
    private final DynamoDbClient dynamoDbClient;
    private final DynamoDbEnhancedClientExtension extension;

    private DefaultDynamoDbEnhancedClient(Builder builder) {
        this.dynamoDbClient = builder.dynamoDbClient == null ? DynamoDbClient.create() : builder.dynamoDbClient;
        this.extension = ExtensionResolver.resolveExtensions(builder.dynamoDbEnhancedClientExtensions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> DefaultDynamoDbTable<T> table(String tableName, TableSchema<T> tableSchema) {
        return new DefaultDynamoDbTable<T>(this.dynamoDbClient, this.extension, tableSchema, tableName);
    }

    @Override
    public BatchGetResultPageIterable batchGetItem(BatchGetItemEnhancedRequest request) {
        BatchGetItemOperation operation = BatchGetItemOperation.create(request);
        return BatchGetResultPageIterable.create(operation.execute(this.dynamoDbClient, this.extension));
    }

    @Override
    public BatchGetResultPageIterable batchGetItem(Consumer<BatchGetItemEnhancedRequest.Builder> requestConsumer) {
        BatchGetItemEnhancedRequest.Builder builder = BatchGetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.batchGetItem(builder.build());
    }

    @Override
    public BatchWriteResult batchWriteItem(BatchWriteItemEnhancedRequest request) {
        BatchWriteItemOperation operation = BatchWriteItemOperation.create(request);
        return (BatchWriteResult)operation.execute(this.dynamoDbClient, this.extension);
    }

    @Override
    public BatchWriteResult batchWriteItem(Consumer<BatchWriteItemEnhancedRequest.Builder> requestConsumer) {
        BatchWriteItemEnhancedRequest.Builder builder = BatchWriteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.batchWriteItem(builder.build());
    }

    @Override
    public List<Document> transactGetItems(TransactGetItemsEnhancedRequest request) {
        TransactGetItemsOperation operation = TransactGetItemsOperation.create(request);
        return (List)operation.execute(this.dynamoDbClient, this.extension);
    }

    @Override
    public List<Document> transactGetItems(Consumer<TransactGetItemsEnhancedRequest.Builder> requestConsumer) {
        TransactGetItemsEnhancedRequest.Builder builder = TransactGetItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactGetItems(builder.build());
    }

    @Override
    public Void transactWriteItems(TransactWriteItemsEnhancedRequest request) {
        TransactWriteItemsOperation operation = TransactWriteItemsOperation.create(request);
        operation.execute(this.dynamoDbClient, this.extension);
        return null;
    }

    @Override
    public Void transactWriteItems(Consumer<TransactWriteItemsEnhancedRequest.Builder> requestConsumer) {
        TransactWriteItemsEnhancedRequest.Builder builder = TransactWriteItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactWriteItems(builder.build());
    }

    @Override
    public TransactWriteItemsEnhancedResponse transactWriteItemsWithResponse(TransactWriteItemsEnhancedRequest request) {
        TransactWriteItemsOperation operation = TransactWriteItemsOperation.create(request);
        return (TransactWriteItemsEnhancedResponse)operation.execute(this.dynamoDbClient, this.extension);
    }

    @Override
    public TransactWriteItemsEnhancedResponse transactWriteItemsWithResponse(Consumer<TransactWriteItemsEnhancedRequest.Builder> requestConsumer) {
        TransactWriteItemsEnhancedRequest.Builder builder = TransactWriteItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactWriteItemsWithResponse(builder.build());
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    public DynamoDbEnhancedClientExtension mapperExtension() {
        return this.extension;
    }

    public Builder toBuilder() {
        return DefaultDynamoDbEnhancedClient.builder().dynamoDbClient(this.dynamoDbClient).extensions(this.extension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbEnhancedClient that = (DefaultDynamoDbEnhancedClient)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        return this.extension != null ? this.extension.equals(that.extension) : that.extension == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder
    implements DynamoDbEnhancedClient.Builder {
        private DynamoDbClient dynamoDbClient;
        private List<DynamoDbEnhancedClientExtension> dynamoDbEnhancedClientExtensions = new ArrayList<DynamoDbEnhancedClientExtension>(ExtensionResolver.defaultExtensions());

        @Override
        public DefaultDynamoDbEnhancedClient build() {
            return new DefaultDynamoDbEnhancedClient(this);
        }

        @Override
        public Builder dynamoDbClient(DynamoDbClient dynamoDbClient) {
            this.dynamoDbClient = dynamoDbClient;
            return this;
        }

        @Override
        public Builder extensions(DynamoDbEnhancedClientExtension ... dynamoDbEnhancedClientExtensions) {
            this.dynamoDbEnhancedClientExtensions = Arrays.asList(dynamoDbEnhancedClientExtensions);
            return this;
        }

        @Override
        public Builder extensions(List<DynamoDbEnhancedClientExtension> dynamoDbEnhancedClientExtensions) {
            this.dynamoDbEnhancedClientExtensions = new ArrayList<DynamoDbEnhancedClientExtension>(dynamoDbEnhancedClientExtensions);
            return this;
        }
    }
}

