/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.logs.v1.LogRecord;
import io.opentelemetry.proto.logs.v1.ResourceLogs;
import io.opentelemetry.proto.metrics.v1.Exemplar;
import io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.ScopeSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.opensearch.dataprepper.model.log.JacksonOtelLog;
import org.opensearch.dataprepper.model.log.OpenTelemetryLog;
import org.opensearch.dataprepper.model.metric.Bucket;
import org.opensearch.dataprepper.model.metric.DefaultBucket;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.opensearch.dataprepper.model.metric.DefaultQuantile;
import org.opensearch.dataprepper.model.metric.JacksonExponentialHistogram;
import org.opensearch.dataprepper.model.metric.JacksonGauge;
import org.opensearch.dataprepper.model.metric.JacksonHistogram;
import org.opensearch.dataprepper.model.metric.JacksonSum;
import org.opensearch.dataprepper.model.metric.JacksonSummary;
import org.opensearch.dataprepper.model.metric.Quantile;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.trace.DefaultLink;
import org.opensearch.dataprepper.model.trace.DefaultSpanEvent;
import org.opensearch.dataprepper.model.trace.DefaultTraceGroupFields;
import org.opensearch.dataprepper.model.trace.JacksonSpan;
import org.opensearch.dataprepper.model.trace.Link;
import org.opensearch.dataprepper.model.trace.SpanEvent;
import org.opensearch.dataprepper.model.trace.TraceGroupFields;
import org.opensearch.dataprepper.plugins.otel.codec.OTelDecodingException;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelProtoOpensearchCodec {
    private static final Logger LOG = LoggerFactory.getLogger(OTelProtoCodec.class);
    public static final int DEFAULT_EXPONENTIAL_HISTOGRAM_MAX_ALLOWED_SCALE = 10;
    private static final double OTEL_NEGATIVE_INFINITY = -3.4028234663852886E38;
    private static final double OTEL_POSITIVE_INFINITY = 3.4028234663852886E38;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final long NANO_MULTIPLIER = 1000000000L;
    protected static final String SERVICE_NAME = "service.name";
    protected static final String SPAN_ATTRIBUTES = "span.attributes";
    static final String RESOURCE_ATTRIBUTES = "resource.attributes";
    static final String STATUS_CODE = "status.code";
    static final String STATUS_MESSAGE = "status.message";
    private static final String DOT = ".";
    private static final String AT = "@";
    private static final String LOG_ATTRIBUTES = "log.attributes";
    private static final String METRIC_ATTRIBUTES = "metric.attributes";
    private static final String EXEMPLAR_ATTRIBUTES = "exemplar.attributes";
    static final String INSTRUMENTATION_SCOPE_NAME = "instrumentationScope.name";
    static final String INSTRUMENTATION_SCOPE_VERSION = "instrumentationScope.version";
    static final String INSTRUMENTATION_SCOPE_ATTRIBUTES = "instrumentationScope.attributes";
    public static final Function<String, String> REPLACE_DOT_WITH_AT = i -> i.replace(DOT, AT);
    public static final Function<String, String> SPAN_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "span.attributes." + i.replace(DOT, AT);
    public static final Function<String, String> RESOURCE_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "resource.attributes." + i.replace(DOT, AT);
    public static final Function<String, String> PREFIX_AND_LOG_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "log.attributes." + i.replace(DOT, AT);
    public static final Function<String, String> PREFIX_AND_METRIC_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "metric.attributes." + i.replace(DOT, AT);
    public static final Function<String, String> PREFIX_AND_RESOURCE_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "resource.attributes." + i.replace(DOT, AT);
    public static final Function<String, String> PREFIX_AND_EXEMPLAR_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "exemplar.attributes." + i.replace(DOT, AT);
    private static final Map<BoundsKey, double[]> EXPONENTIAL_BUCKET_BOUNDS = new ConcurrentHashMap<BoundsKey, double[]>();

    public static Object convertAnyValue(AnyValue value) {
        switch (value.getValueCase()) {
            case VALUE_NOT_SET: 
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case INT_VALUE: {
                return value.getIntValue();
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case ARRAY_VALUE: {
                try {
                    return OBJECT_MAPPER.writeValueAsString(value.getArrayValue().getValuesList().stream().map(OTelProtoOpensearchCodec::convertAnyValue).collect(Collectors.toList()));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case KVLIST_VALUE: {
                try {
                    return OBJECT_MAPPER.writeValueAsString(value.getKvlistValue().getValuesList().stream().collect(Collectors.toMap(i -> REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue()))));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new RuntimeException(String.format("Can not convert AnyValue of type %s", value.getValueCase()));
    }

    public static Map<String, Object> convertKeysOfDataPointAttributes(NumberDataPoint numberDataPoint) {
        return numberDataPoint.getAttributesList().stream().collect(Collectors.toMap(i -> PREFIX_AND_METRIC_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue())));
    }

    public static Map<String, Object> unpackKeyValueListMetric(List<KeyValue> attributesList) {
        return attributesList.stream().collect(Collectors.toMap(i -> PREFIX_AND_METRIC_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue())));
    }

    public static Map<String, Object> unpackKeyValueList(List<KeyValue> attributesList) {
        return attributesList.stream().collect(Collectors.toMap(i -> DOT + i.getKey().replace(DOT, AT), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue())));
    }

    public static Map<String, Object> unpackKeyValueListLog(List<KeyValue> attributesList) {
        return attributesList.stream().collect(Collectors.toMap(i -> PREFIX_AND_LOG_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue())));
    }

    public static Map<String, Object> unpackExemplarValueList(List<KeyValue> attributesList) {
        return attributesList.stream().collect(Collectors.toMap(i -> PREFIX_AND_EXEMPLAR_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue())));
    }

    public static Double getValueAsDouble(NumberDataPoint ndp) {
        NumberDataPoint.ValueCase ndpCase = ndp.getValueCase();
        if (NumberDataPoint.ValueCase.AS_DOUBLE == ndpCase) {
            return ndp.getAsDouble();
        }
        if (NumberDataPoint.ValueCase.AS_INT == ndpCase) {
            return ndp.getAsInt();
        }
        return null;
    }

    public static Double getExemplarValueAsDouble(Exemplar exemplar) {
        Exemplar.ValueCase valueCase = exemplar.getValueCase();
        if (Exemplar.ValueCase.AS_DOUBLE == valueCase) {
            return exemplar.getAsDouble();
        }
        if (Exemplar.ValueCase.AS_INT == valueCase) {
            return exemplar.getAsInt();
        }
        return null;
    }

    public static Map<String, Object> getResourceAttributes(Resource resource) {
        return resource.getAttributesList().stream().collect(Collectors.toMap(i -> PREFIX_AND_RESOURCE_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelProtoOpensearchCodec.convertAnyValue(i.getValue())));
    }

    public static Map<String, Object> getInstrumentationScopeAttributes(InstrumentationScope instrumentationScope) {
        HashMap<String, Object> instrumentationScopeAttr = new HashMap<String, Object>();
        if (!instrumentationScope.getName().isEmpty()) {
            instrumentationScopeAttr.put(INSTRUMENTATION_SCOPE_NAME, instrumentationScope.getName());
        }
        if (!instrumentationScope.getVersion().isEmpty()) {
            instrumentationScopeAttr.put(INSTRUMENTATION_SCOPE_VERSION, instrumentationScope.getVersion());
        }
        if (!instrumentationScope.getAttributesList().isEmpty()) {
            for (Map.Entry<String, Object> entry : OTelProtoOpensearchCodec.unpackKeyValueList(instrumentationScope.getAttributesList()).entrySet()) {
                instrumentationScopeAttr.put(INSTRUMENTATION_SCOPE_ATTRIBUTES + entry.getKey(), entry.getValue());
            }
        }
        return instrumentationScopeAttr;
    }

    public static Optional<String> getServiceName(Resource resource) {
        return resource.getAttributesList().stream().filter(keyValue -> keyValue.getKey().equals(SERVICE_NAME) && !keyValue.getValue().getStringValue().isEmpty()).findFirst().map(i -> i.getValue().getStringValue());
    }

    public static Map<String, Object> mergeAllAttributes(Collection<Map<String, Object>> attributes) {
        return attributes.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<Quantile> getQuantileValues(List<SummaryDataPoint.ValueAtQuantile> quantileValues) {
        return quantileValues.stream().map(q -> new DefaultQuantile(Double.valueOf(q.getQuantile()), Double.valueOf(q.getValue()))).collect(Collectors.toList());
    }

    public static List<Bucket> createBuckets(List<Long> bucketCountsList, List<Double> explicitBoundsList) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        if (bucketCountsList.isEmpty()) {
            return buckets;
        }
        if (bucketCountsList.size() - 1 != explicitBoundsList.size()) {
            LOG.error("bucket count list not equals to bounds list {} {}", (Object)bucketCountsList.size(), (Object)explicitBoundsList.size());
            throw new IllegalArgumentException("OpenTelemetry protocol mandates that the number of elements in bucket_counts array must be by one greater than\n  // the number of elements in explicit_bounds array.");
        }
        if (bucketCountsList.size() == 1) {
            double min = -3.4028234663852886E38;
            double max = 3.4028234663852886E38;
            Long bucketCount = bucketCountsList.get(0);
            buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
        } else {
            for (int i = 0; i < bucketCountsList.size(); ++i) {
                Long bucketCount;
                double max;
                double min;
                if (i == 0) {
                    min = -3.4028234663852886E38;
                    max = explicitBoundsList.get(i);
                    bucketCount = bucketCountsList.get(i);
                    buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
                    continue;
                }
                if (i == bucketCountsList.size() - 1) {
                    min = explicitBoundsList.get(i - 1);
                    max = 3.4028234663852886E38;
                    bucketCount = bucketCountsList.get(i);
                    buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
                    continue;
                }
                min = explicitBoundsList.get(i - 1);
                max = explicitBoundsList.get(i);
                bucketCount = bucketCountsList.get(i);
                buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
            }
        }
        return buckets;
    }

    public static List<org.opensearch.dataprepper.model.metric.Exemplar> convertExemplars(List<Exemplar> exemplarsList) {
        return exemplarsList.stream().map(exemplar -> new DefaultExemplar(OTelProtoCommonUtils.convertUnixNanosToISO8601(exemplar.getTimeUnixNano()), OTelProtoOpensearchCodec.getExemplarValueAsDouble(exemplar), OTelProtoCommonUtils.convertByteStringToString(exemplar.getSpanId()), OTelProtoCommonUtils.convertByteStringToString(exemplar.getTraceId()), OTelProtoOpensearchCodec.unpackExemplarValueList(exemplar.getFilteredAttributesList()))).collect(Collectors.toList());
    }

    static double[] calculateBoundsForScale(BoundsKey key) {
        double base = Math.pow(2.0, Math.pow(2.0, -key.getScale().intValue()));
        int maxIndex = Math.toIntExact(Math.round(Math.log(Double.MAX_VALUE) / Math.log(base)));
        double[] boundaries = new double[maxIndex + 1];
        for (int i = 0; i <= maxIndex; ++i) {
            boundaries[i] = Math.pow(base, key.getSign() == BoundsKey.Sign.POSITIVE ? (double)i : (double)(-i));
        }
        return boundaries;
    }

    public static List<Bucket> createExponentialBuckets(ExponentialHistogramDataPoint.Buckets buckets, int scale) {
        int offset = buckets.getOffset();
        BoundsKey key = new BoundsKey(scale, offset < 0 ? BoundsKey.Sign.NEGATIVE : BoundsKey.Sign.POSITIVE);
        double[] bucketBounds = EXPONENTIAL_BUCKET_BOUNDS.computeIfAbsent(key, boundsKey -> OTelProtoOpensearchCodec.calculateBoundsForScale(key));
        ArrayList<Bucket> mappedBuckets = new ArrayList<Bucket>();
        List bucketsList = buckets.getBucketCountsList();
        int boundOffset = Math.abs(offset);
        if (bucketsList.size() + boundOffset >= bucketBounds.length) {
            LOG.error("Max offset is out of range for Double data type, ignoring buckets");
        } else {
            for (int i = 0; i < bucketsList.size(); ++i) {
                Long value = (Long)bucketsList.get(i);
                double lowerBound = bucketBounds[boundOffset + i];
                double upperBound = bucketBounds[boundOffset + i + 1];
                mappedBuckets.add((Bucket)new DefaultBucket(Double.valueOf(lowerBound), Double.valueOf(upperBound), value));
            }
        }
        return mappedBuckets;
    }

    public static class OTelProtoEncoder
    implements OTelProtoCodec.OTelProtoEncoder {
        protected static final String SERVICE_NAME_ATTRIBUTE = "service@name";
        protected static final String RESOURCE_ATTRIBUTES_PREFIX = "resource.attributes.";
        protected static final String SPAN_ATTRIBUTES_PREFIX = "span.attributes.";

        @Override
        public ResourceSpans convertToResourceSpans(org.opensearch.dataprepper.model.trace.Span span) throws UnsupportedEncodingException, DecoderException {
            ResourceSpans.Builder rsBuilder = ResourceSpans.newBuilder();
            Map allAttributes = span.getAttributes();
            Resource resource = this.constructResource(span.getServiceName(), allAttributes);
            rsBuilder.setResource(resource);
            ScopeSpans.Builder scopeSpansBuilder = ScopeSpans.newBuilder();
            InstrumentationScope instrumentationScope = this.constructInstrumentationScope(allAttributes);
            scopeSpansBuilder.setScope(instrumentationScope);
            Span otelProtoSpan = this.constructSpan(span, allAttributes);
            scopeSpansBuilder.addSpans(otelProtoSpan);
            rsBuilder.addScopeSpans(scopeSpansBuilder);
            return rsBuilder.build();
        }

        protected List<KeyValue> getSpanAttributes(Map<String, Object> attributes) throws UnsupportedEncodingException {
            List spanAttributeKeys = attributes.keySet().stream().filter(key -> key.startsWith(SPAN_ATTRIBUTES_PREFIX)).collect(Collectors.toList());
            ArrayList<KeyValue> result = new ArrayList<KeyValue>();
            for (String key2 : spanAttributeKeys) {
                String trimmedKey = key2.substring(SPAN_ATTRIBUTES_PREFIX.length());
                KeyValue keyValue = KeyValue.newBuilder().setKey(trimmedKey).setValue(this.objectToAnyValue(attributes.get(key2))).build();
                result.add(keyValue);
            }
            return result;
        }

        protected Resource constructResource(String serviceName, Map<String, Object> attributes) throws UnsupportedEncodingException {
            Resource.Builder rsBuilder = Resource.newBuilder();
            List<KeyValue> resourceAttributes = this.getResourceAttributes(attributes);
            rsBuilder.addAllAttributes(resourceAttributes);
            if (serviceName != null) {
                KeyValue.Builder serviceNameKeyValueBuilder = KeyValue.newBuilder().setKey(OTelProtoOpensearchCodec.SERVICE_NAME).setValue(this.objectToAnyValue(serviceName));
                rsBuilder.addAttributes(serviceNameKeyValueBuilder);
            }
            return rsBuilder.build();
        }

        protected List<KeyValue> getResourceAttributes(Map<String, Object> attributes) throws UnsupportedEncodingException {
            List resourceAttributeKeys = attributes.keySet().stream().filter(key -> key.startsWith(RESOURCE_ATTRIBUTES_PREFIX)).collect(Collectors.toList());
            ArrayList<KeyValue> result = new ArrayList<KeyValue>();
            for (String key2 : resourceAttributeKeys) {
                String trimmedKey = key2.substring(RESOURCE_ATTRIBUTES_PREFIX.length());
                if (trimmedKey.equals(SERVICE_NAME_ATTRIBUTE)) continue;
                KeyValue keyValue = KeyValue.newBuilder().setKey(trimmedKey).setValue(this.objectToAnyValue(attributes.get(key2))).build();
                result.add(keyValue);
            }
            return result;
        }

        protected InstrumentationScope constructInstrumentationScope(Map<String, Object> attributes) throws UnsupportedEncodingException, DecoderException {
            InstrumentationScope.Builder builder = InstrumentationScope.newBuilder();
            ArrayList<KeyValue> attributeKeyValueList = new ArrayList<KeyValue>();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                if (entry.getKey().equals(OTelProtoOpensearchCodec.INSTRUMENTATION_SCOPE_NAME)) {
                    builder.setName((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals(OTelProtoOpensearchCodec.INSTRUMENTATION_SCOPE_VERSION)) {
                    builder.setVersion((String)entry.getValue());
                    continue;
                }
                if (!entry.getKey().startsWith(OTelProtoOpensearchCodec.INSTRUMENTATION_SCOPE_ATTRIBUTES)) continue;
                KeyValue.Builder setValue = KeyValue.newBuilder().setKey(entry.getKey().substring(OTelProtoOpensearchCodec.INSTRUMENTATION_SCOPE_ATTRIBUTES.length() + 1)).setValue(this.objectToAnyValue(entry.getValue()));
                attributeKeyValueList.add(setValue.build());
            }
            builder.addAllAttributes(attributeKeyValueList);
            return builder.build();
        }

        protected Status constructSpanStatus(Map<String, Object> attributes) {
            Status.Builder builder = Status.newBuilder();
            Optional<Integer> statusCode = Optional.ofNullable((Integer)attributes.get(OTelProtoOpensearchCodec.STATUS_CODE));
            Optional<String> statusMessage = Optional.ofNullable((String)attributes.get(OTelProtoOpensearchCodec.STATUS_MESSAGE));
            statusCode.ifPresent(arg_0 -> ((Status.Builder)builder).setCodeValue(arg_0));
            statusMessage.ifPresent(arg_0 -> ((Status.Builder)builder).setMessage(arg_0));
            return builder.build();
        }

        protected List<Span.Event> convertSpanEvents(List<? extends SpanEvent> spanEvents) throws UnsupportedEncodingException {
            ArrayList<Span.Event> result = new ArrayList<Span.Event>();
            for (SpanEvent spanEvent : spanEvents) {
                result.add(this.convertSpanEvent(spanEvent));
            }
            return result;
        }

        protected Span.Event convertSpanEvent(SpanEvent spanEvent) throws UnsupportedEncodingException {
            Span.Event.Builder builder = Span.Event.newBuilder();
            builder.setName(spanEvent.getName());
            builder.setTimeUnixNano(OTelProtoCommonUtils.convertISO8601ToNanos(spanEvent.getTime()));
            builder.setDroppedAttributesCount(spanEvent.getDroppedAttributesCount().intValue());
            ArrayList<KeyValue> attributeKeyValueList = new ArrayList<KeyValue>();
            for (Map.Entry entry : spanEvent.getAttributes().entrySet()) {
                KeyValue.Builder setValue = KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(this.objectToAnyValue(entry.getValue()));
                attributeKeyValueList.add(setValue.build());
            }
            builder.addAllAttributes(attributeKeyValueList);
            return builder.build();
        }

        protected List<Span.Link> convertSpanLinks(List<? extends Link> links) throws DecoderException, UnsupportedEncodingException {
            ArrayList<Span.Link> result = new ArrayList<Span.Link>();
            for (Link link : links) {
                result.add(this.convertSpanLink(link));
            }
            return result;
        }

        protected Span.Link convertSpanLink(Link link) throws DecoderException, UnsupportedEncodingException {
            Span.Link.Builder builder = Span.Link.newBuilder();
            builder.setSpanId(ByteString.copyFrom((byte[])Hex.decodeHex((String)link.getSpanId())));
            builder.setTraceId(ByteString.copyFrom((byte[])Hex.decodeHex((String)link.getTraceId())));
            builder.setTraceState(link.getTraceState());
            builder.setDroppedAttributesCount(link.getDroppedAttributesCount().intValue());
            ArrayList<KeyValue> attributeKeyValueList = new ArrayList<KeyValue>();
            for (Map.Entry entry : link.getAttributes().entrySet()) {
                KeyValue.Builder setValue = KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(this.objectToAnyValue(entry.getValue()));
                attributeKeyValueList.add(setValue.build());
            }
            builder.addAllAttributes(attributeKeyValueList);
            return builder.build();
        }

        protected Span constructSpan(org.opensearch.dataprepper.model.trace.Span span, Map<String, Object> allAttributes) throws DecoderException, UnsupportedEncodingException {
            Span.Builder builder = Span.newBuilder().setSpanId(ByteString.copyFrom((byte[])Hex.decodeHex((String)span.getSpanId()))).setParentSpanId(ByteString.copyFrom((byte[])Hex.decodeHex((String)span.getParentSpanId()))).setTraceId(ByteString.copyFrom((byte[])Hex.decodeHex((String)span.getTraceId()))).setTraceState(span.getTraceState()).setName(span.getName()).setKind(Span.SpanKind.valueOf((String)span.getKind())).setStartTimeUnixNano(OTelProtoCommonUtils.convertISO8601ToNanos(span.getStartTime())).setEndTimeUnixNano(OTelProtoCommonUtils.convertISO8601ToNanos(span.getEndTime())).setDroppedAttributesCount(span.getDroppedAttributesCount().intValue()).setDroppedEventsCount(span.getDroppedEventsCount().intValue()).setDroppedLinksCount(span.getDroppedLinksCount().intValue());
            builder.setStatus(this.constructSpanStatus(allAttributes)).addAllAttributes(this.getSpanAttributes(allAttributes)).addAllEvents(this.convertSpanEvents(span.getEvents())).addAllLinks(this.convertSpanLinks(span.getLinks()));
            return builder.build();
        }

        protected AnyValue objectToAnyValue(Object obj) throws UnsupportedEncodingException {
            AnyValue.Builder anyValueBuilder = AnyValue.newBuilder();
            if (obj == null) {
                return anyValueBuilder.build();
            }
            if (obj instanceof Integer || obj instanceof Long) {
                anyValueBuilder.setIntValue(((Number)obj).longValue());
            } else if (obj instanceof String) {
                anyValueBuilder.setStringValue((String)obj);
            } else if (obj instanceof Boolean) {
                anyValueBuilder.setBoolValue(((Boolean)obj).booleanValue());
            } else if (obj instanceof Double) {
                anyValueBuilder.setDoubleValue(((Double)obj).doubleValue());
            } else {
                throw new UnsupportedEncodingException(String.format("Unsupported object type: %s in io.opentelemetry.proto.common.v1.AnyValue encoding", obj.getClass().toString()));
            }
            return anyValueBuilder.build();
        }
    }

    public static class OTelProtoDecoder
    implements OTelProtoCodec.OTelProtoDecoder {
        @Override
        public List<org.opensearch.dataprepper.model.trace.Span> parseExportTraceServiceRequest(ExportTraceServiceRequest exportTraceServiceRequest, Instant timeReceived) {
            return exportTraceServiceRequest.getResourceSpansList().stream().flatMap(rs -> this.parseResourceSpans((ResourceSpans)rs, timeReceived).stream()).collect(Collectors.toList());
        }

        @Override
        public Map<String, ExportTraceServiceRequest> splitExportTraceServiceRequestByTraceId(ExportTraceServiceRequest exportTraceServiceRequest) {
            HashMap<String, ExportTraceServiceRequest> result = new HashMap<String, ExportTraceServiceRequest>();
            HashMap<String, ExportTraceServiceRequest.Builder> resultBuilderMap = new HashMap<String, ExportTraceServiceRequest.Builder>();
            for (ResourceSpans resourceSpans : exportTraceServiceRequest.getResourceSpansList()) {
                for (Map.Entry<String, ResourceSpans> entry : this.splitResourceSpansByTraceId(resourceSpans).entrySet()) {
                    String traceId = entry.getKey();
                    if (resultBuilderMap.containsKey(traceId)) {
                        ((ExportTraceServiceRequest.Builder)resultBuilderMap.get(traceId)).addResourceSpans(entry.getValue());
                        continue;
                    }
                    resultBuilderMap.put(traceId, ExportTraceServiceRequest.newBuilder().addResourceSpans(entry.getValue()));
                }
            }
            for (Map.Entry entry : resultBuilderMap.entrySet()) {
                result.put((String)entry.getKey(), ((ExportTraceServiceRequest.Builder)entry.getValue()).build());
            }
            return result;
        }

        @Override
        public List<OpenTelemetryLog> parseExportLogsServiceRequest(ExportLogsServiceRequest exportLogsServiceRequest, Instant timeReceived) {
            return exportLogsServiceRequest.getResourceLogsList().stream().flatMap(rs -> this.parseResourceLogs((ResourceLogs)rs, timeReceived)).collect(Collectors.toList());
        }

        protected Stream<OpenTelemetryLog> parseResourceLogs(ResourceLogs rs, Instant timeReceived) {
            String serviceName = OTelProtoOpensearchCodec.getServiceName(rs.getResource()).orElse(null);
            Map<String, Object> resourceAttributes = OTelProtoOpensearchCodec.getResourceAttributes(rs.getResource());
            String schemaUrl = rs.getSchemaUrl();
            Stream<OpenTelemetryLog> mappedScopeListLogs = rs.getScopeLogsList().stream().map(sls -> this.processLogsList(sls.getLogRecordsList(), serviceName, OTelProtoOpensearchCodec.getInstrumentationScopeAttributes(sls.getScope()), resourceAttributes, schemaUrl, timeReceived)).flatMap(Collection::stream);
            return mappedScopeListLogs;
        }

        protected Map<String, ResourceSpans> splitResourceSpansByTraceId(ResourceSpans resourceSpans) {
            Resource resource = resourceSpans.getResource();
            boolean hasResource = resourceSpans.hasResource();
            HashMap<String, ResourceSpans> result = new HashMap<String, ResourceSpans>();
            HashMap<String, ResourceSpans.Builder> resultBuilderMap = new HashMap<String, ResourceSpans.Builder>();
            if (!resourceSpans.getScopeSpansList().isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.splitScopeSpansByTraceId(resourceSpans.getScopeSpansList()).entrySet()) {
                    ResourceSpans.Builder resourceSpansBuilder = ResourceSpans.newBuilder().addAllScopeSpans((Iterable)entry.getValue());
                    if (hasResource) {
                        resourceSpansBuilder.setResource(resource);
                    }
                    resultBuilderMap.put((String)entry.getKey(), resourceSpansBuilder);
                }
            }
            for (Map.Entry<Object, Object> entry : resultBuilderMap.entrySet()) {
                result.put((String)entry.getKey(), ((ResourceSpans.Builder)entry.getValue()).build());
            }
            return result;
        }

        protected List<org.opensearch.dataprepper.model.trace.Span> parseResourceSpans(ResourceSpans resourceSpans, Instant timeReceived) {
            String serviceName = this.getServiceName(resourceSpans.getResource()).orElse(null);
            Map<String, Object> resourceAttributes = this.getResourceAttributes(resourceSpans.getResource());
            if (!resourceSpans.getScopeSpansList().isEmpty()) {
                return this.parseScopeSpans(resourceSpans.getScopeSpansList(), serviceName, resourceAttributes, timeReceived);
            }
            LOG.debug("No spans found to parse from ResourceSpans object: {}", (Object)resourceSpans);
            return Collections.emptyList();
        }

        private List<org.opensearch.dataprepper.model.trace.Span> parseScopeSpans(List<ScopeSpans> scopeSpansList, String serviceName, Map<String, Object> resourceAttributes, Instant timeReceived) {
            return scopeSpansList.stream().map(scopeSpans -> this.parseSpans(scopeSpans.getSpansList(), scopeSpans.getScope(), OTelProtoOpensearchCodec::getInstrumentationScopeAttributes, serviceName, resourceAttributes, timeReceived)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Map<String, List<ScopeSpans>> splitScopeSpansByTraceId(List<ScopeSpans> scopeSpansList) {
            HashMap<String, List<ScopeSpans>> result = new HashMap<String, List<ScopeSpans>>();
            for (ScopeSpans ss : scopeSpansList) {
                boolean hasScope = ss.hasScope();
                InstrumentationScope scope = ss.getScope();
                for (Map.Entry<String, List<Span>> entry : this.splitSpansByTraceId(ss.getSpansList()).entrySet()) {
                    String traceId;
                    ScopeSpans.Builder scopeSpansBuilder = ScopeSpans.newBuilder().addAllSpans((Iterable)entry.getValue());
                    if (hasScope) {
                        scopeSpansBuilder.setScope(scope);
                    }
                    if (!result.containsKey(traceId = entry.getKey())) {
                        result.put(traceId, new ArrayList());
                    }
                    ((List)result.get(traceId)).add(scopeSpansBuilder.build());
                }
            }
            return result;
        }

        private Map<String, List<Span>> splitSpansByTraceId(List<Span> spans) {
            HashMap<String, List<Span>> result = new HashMap<String, List<Span>>();
            for (Span span : spans) {
                List<Span> spanList;
                String traceId = OTelProtoCommonUtils.convertByteStringToString(span.getTraceId());
                if (result.containsKey(traceId)) {
                    spanList = (List)result.get(traceId);
                } else {
                    spanList = new ArrayList();
                    result.put(traceId, spanList);
                }
                spanList.add(span);
            }
            return result;
        }

        private <T> List<org.opensearch.dataprepper.model.trace.Span> parseSpans(List<Span> spans, T scope, Function<T, Map<String, Object>> scopeAttributesGetter, String serviceName, Map<String, Object> resourceAttributes, Instant timeReceived) {
            return spans.stream().map(span -> {
                Map scopeAttributes = (Map)scopeAttributesGetter.apply(scope);
                return this.parseSpan((Span)span, scopeAttributes, serviceName, resourceAttributes, timeReceived);
            }).collect(Collectors.toList());
        }

        protected List<OpenTelemetryLog> processLogsList(List<LogRecord> logsList, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived) {
            return logsList.stream().map(log -> JacksonOtelLog.builder().withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(log.getTimeUnixNano())).withObservedTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(log.getObservedTimeUnixNano())).withServiceName(serviceName).withAttributes(this.mergeAllAttributes(Arrays.asList(OTelProtoOpensearchCodec.unpackKeyValueListLog(log.getAttributesList()), resourceAttributes, ils))).withSchemaUrl(schemaUrl).withFlags(Integer.valueOf(log.getFlags())).withTraceId(OTelProtoCommonUtils.convertByteStringToString(log.getTraceId())).withSpanId(OTelProtoCommonUtils.convertByteStringToString(log.getSpanId())).withSeverityNumber(Integer.valueOf(log.getSeverityNumberValue())).withSeverityText(log.getSeverityText()).withDroppedAttributesCount(Integer.valueOf(log.getDroppedAttributesCount())).withBody(this.convertAnyValue(log.getBody())).withTimeReceived(timeReceived).build()).collect(Collectors.toList());
        }

        protected org.opensearch.dataprepper.model.trace.Span parseSpan(Span sp, Map<String, Object> instrumentationScopeAttributes, String serviceName, Map<String, Object> resourceAttributes, Instant timeReceived) {
            return JacksonSpan.builder().withSpanId(OTelProtoCommonUtils.convertByteStringToString(sp.getSpanId())).withTraceId(OTelProtoCommonUtils.convertByteStringToString(sp.getTraceId())).withTraceState(sp.getTraceState()).withParentSpanId(OTelProtoCommonUtils.convertByteStringToString(sp.getParentSpanId())).withName(sp.getName()).withServiceName(serviceName).withKind(sp.getKind().name()).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(sp.getStartTimeUnixNano())).withEndTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(sp.getEndTimeUnixNano())).withAttributes(this.mergeAllAttributes(Arrays.asList(this.getSpanAttributes(sp), resourceAttributes, instrumentationScopeAttributes, this.getSpanStatusAttributes(sp.getStatus())))).withDroppedAttributesCount(Integer.valueOf(sp.getDroppedAttributesCount())).withEvents(sp.getEventsList().stream().map(this::getSpanEvent).collect(Collectors.toList())).withDroppedEventsCount(Integer.valueOf(sp.getDroppedEventsCount())).withLinks(sp.getLinksList().stream().map(this::getLink).collect(Collectors.toList())).withDroppedLinksCount(Integer.valueOf(sp.getDroppedLinksCount())).withTraceGroup(this.getTraceGroup(sp)).withDurationInNanos(Long.valueOf(sp.getEndTimeUnixNano() - sp.getStartTimeUnixNano())).withTraceGroupFields(this.getTraceGroupFields(sp)).withTimeReceived(timeReceived).build();
        }

        protected Object convertAnyValue(AnyValue value) {
            switch (value.getValueCase()) {
                case VALUE_NOT_SET: 
                case STRING_VALUE: {
                    return value.getStringValue();
                }
                case BOOL_VALUE: {
                    return value.getBoolValue();
                }
                case INT_VALUE: {
                    return value.getIntValue();
                }
                case DOUBLE_VALUE: {
                    return value.getDoubleValue();
                }
                case ARRAY_VALUE: {
                    try {
                        return OBJECT_MAPPER.writeValueAsString(value.getArrayValue().getValuesList().stream().map(this::convertAnyValue).collect(Collectors.toList()));
                    }
                    catch (JsonProcessingException e) {
                        throw new OTelDecodingException(e);
                    }
                }
                case KVLIST_VALUE: {
                    try {
                        return OBJECT_MAPPER.writeValueAsString(value.getKvlistValue().getValuesList().stream().collect(Collectors.toMap(i -> REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> this.convertAnyValue(i.getValue()))));
                    }
                    catch (JsonProcessingException e) {
                        throw new OTelDecodingException(e);
                    }
                }
            }
            throw new OTelDecodingException("Unknown case");
        }

        protected Map<String, Object> mergeAllAttributes(Collection<Map<String, Object>> attributes) {
            return attributes.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        protected SpanEvent getSpanEvent(Span.Event event) {
            return DefaultSpanEvent.builder().withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(event.getTimeUnixNano())).withName(event.getName()).withAttributes(this.getEventAttributes(event)).withDroppedAttributesCount(Integer.valueOf(event.getDroppedAttributesCount())).build();
        }

        protected Link getLink(Span.Link link) {
            return DefaultLink.builder().withSpanId(OTelProtoCommonUtils.convertByteStringToString(link.getSpanId())).withTraceId(OTelProtoCommonUtils.convertByteStringToString(link.getTraceId())).withTraceState(link.getTraceState()).withDroppedAttributesCount(Integer.valueOf(link.getDroppedAttributesCount())).withAttributes(this.getLinkAttributes(link)).build();
        }

        protected Map<String, Object> getSpanAttributes(Span span) {
            return span.getAttributesList().stream().collect(Collectors.toMap(i -> SPAN_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> this.convertAnyValue(i.getValue())));
        }

        protected Map<String, Object> getResourceAttributes(Resource resource) {
            return resource.getAttributesList().stream().collect(Collectors.toMap(i -> RESOURCE_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> this.convertAnyValue(i.getValue())));
        }

        protected Map<String, Object> getLinkAttributes(Span.Link link) {
            return link.getAttributesList().stream().collect(Collectors.toMap(i -> REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> this.convertAnyValue(i.getValue())));
        }

        protected Map<String, Object> getEventAttributes(Span.Event event) {
            return event.getAttributesList().stream().collect(Collectors.toMap(i -> REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> this.convertAnyValue(i.getValue())));
        }

        protected String getTraceGroup(Span span) {
            return span.getParentSpanId().isEmpty() ? span.getName() : null;
        }

        protected TraceGroupFields getTraceGroupFields(Span span) {
            DefaultTraceGroupFields.Builder traceGroupFieldsBuilder = DefaultTraceGroupFields.builder();
            if (span.getParentSpanId().isEmpty()) {
                traceGroupFieldsBuilder = traceGroupFieldsBuilder.withDurationInNanos(Long.valueOf(span.getEndTimeUnixNano() - span.getStartTimeUnixNano())).withEndTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(span.getEndTimeUnixNano())).withStatusCode(Integer.valueOf(span.getStatus().getCodeValue()));
            }
            return traceGroupFieldsBuilder.build();
        }

        protected Map<String, Object> getSpanStatusAttributes(Status status) {
            HashMap<String, Object> statusAttr = new HashMap<String, Object>();
            statusAttr.put(OTelProtoOpensearchCodec.STATUS_CODE, status.getCodeValue());
            if (!status.getMessage().isEmpty()) {
                statusAttr.put(OTelProtoOpensearchCodec.STATUS_MESSAGE, status.getMessage());
            }
            return statusAttr;
        }

        protected Optional<String> getServiceName(Resource resource) {
            return resource.getAttributesList().stream().filter(keyValue -> keyValue.getKey().equals(OTelProtoOpensearchCodec.SERVICE_NAME) && !keyValue.getValue().getStringValue().isEmpty()).findFirst().map(i -> i.getValue().getStringValue());
        }

        @Override
        public Collection<Record<? extends org.opensearch.dataprepper.model.metric.Metric>> parseExportMetricsServiceRequest(ExportMetricsServiceRequest request, AtomicInteger droppedCounter, Integer exponentialHistogramMaxAllowedScale, Instant timeReceived, boolean calculateHistogramBuckets, boolean calculateExponentialHistogramBuckets, boolean flattenAttributes) {
            ArrayList<Record<? extends org.opensearch.dataprepper.model.metric.Metric>> recordsOut = new ArrayList<Record<? extends org.opensearch.dataprepper.model.metric.Metric>>();
            for (ResourceMetrics rs : request.getResourceMetricsList()) {
                String schemaUrl = rs.getSchemaUrl();
                Map<String, Object> resourceAttributes = OTelProtoOpensearchCodec.getResourceAttributes(rs.getResource());
                String serviceName = OTelProtoOpensearchCodec.getServiceName(rs.getResource()).orElse(null);
                for (ScopeMetrics sm : rs.getScopeMetricsList()) {
                    Map<String, Object> ils = OTelProtoOpensearchCodec.getInstrumentationScopeAttributes(sm.getScope());
                    recordsOut.addAll(this.processMetricsList(sm.getMetricsList(), serviceName, ils, resourceAttributes, schemaUrl, droppedCounter, exponentialHistogramMaxAllowedScale, timeReceived, calculateHistogramBuckets, calculateExponentialHistogramBuckets, flattenAttributes));
                }
            }
            return recordsOut;
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> processMetricsList(List<Metric> metricsList, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, AtomicInteger droppedCounter, Integer exponentialHistogramMaxAllowedScale, Instant timeReceived, boolean calculateHistogramBuckets, boolean calculateExponentialHistogramBuckets, boolean flattenAttributes) {
            ArrayList<Object> recordsOut = new ArrayList<Object>();
            for (Metric metric : metricsList) {
                try {
                    if (metric.hasGauge()) {
                        recordsOut.addAll(this.mapGauge(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived, flattenAttributes));
                        continue;
                    }
                    if (metric.hasSum()) {
                        recordsOut.addAll(this.mapSum(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived, flattenAttributes));
                        continue;
                    }
                    if (metric.hasSummary()) {
                        recordsOut.addAll(this.mapSummary(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived, flattenAttributes));
                        continue;
                    }
                    if (metric.hasHistogram()) {
                        recordsOut.addAll(this.mapHistogram(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived, calculateHistogramBuckets, flattenAttributes));
                        continue;
                    }
                    if (!metric.hasExponentialHistogram()) continue;
                    recordsOut.addAll(this.mapExponentialHistogram(metric, serviceName, ils, resourceAttributes, schemaUrl, exponentialHistogramMaxAllowedScale, timeReceived, calculateExponentialHistogramBuckets, flattenAttributes));
                }
                catch (Exception e) {
                    LOG.warn("Error while processing metrics", (Throwable)e);
                    droppedCounter.incrementAndGet();
                }
            }
            return recordsOut;
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapGauge(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived, boolean flattenAttributes) {
            return metric.getGauge().getDataPointsList().stream().map(dp -> ((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)JacksonGauge.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withServiceName(serviceName)).withValue(OTelProtoOpensearchCodec.getValueAsDouble(dp)).withAttributes(OTelProtoOpensearchCodec.mergeAllAttributes(Arrays.asList(OTelProtoOpensearchCodec.convertKeysOfDataPointAttributes(dp), resourceAttributes, ils)))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoOpensearchCodec.convertExemplars(dp.getExemplarsList()))).withFlags(Integer.valueOf(dp.getFlags()))).withTimeReceived(timeReceived).build(flattenAttributes)).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapSum(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived, boolean flattenAttributes) {
            return metric.getSum().getDataPointsList().stream().map(dp -> ((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)JacksonSum.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withServiceName(serviceName)).withIsMonotonic(metric.getSum().getIsMonotonic()).withValue(OTelProtoOpensearchCodec.getValueAsDouble(dp)).withAggregationTemporality(metric.getSum().getAggregationTemporality().toString()).withAttributes(OTelProtoOpensearchCodec.mergeAllAttributes(Arrays.asList(OTelProtoOpensearchCodec.convertKeysOfDataPointAttributes(dp), resourceAttributes, ils)))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoOpensearchCodec.convertExemplars(dp.getExemplarsList()))).withFlags(Integer.valueOf(dp.getFlags()))).withTimeReceived(timeReceived).build(flattenAttributes)).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapSummary(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived, boolean flattenAttributes) {
            return metric.getSummary().getDataPointsList().stream().map(dp -> ((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)JacksonSummary.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withServiceName(serviceName)).withCount(Long.valueOf(dp.getCount())).withSum(dp.getSum()).withQuantiles(OTelProtoOpensearchCodec.getQuantileValues(dp.getQuantileValuesList())).withQuantilesValueCount(dp.getQuantileValuesCount()).withAttributes(OTelProtoOpensearchCodec.mergeAllAttributes(Arrays.asList(OTelProtoOpensearchCodec.unpackKeyValueListMetric(dp.getAttributesList()), resourceAttributes, ils)))).withSchemaUrl(schemaUrl)).withFlags(Integer.valueOf(dp.getFlags()))).withTimeReceived(timeReceived).build(flattenAttributes)).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapHistogram(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived, boolean calculateHistogramBuckets, boolean flattenAttributes) {
            return metric.getHistogram().getDataPointsList().stream().map(dp -> {
                JacksonHistogram.Builder builder = (JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)JacksonHistogram.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withServiceName(serviceName)).withSum(dp.getSum()).withCount(dp.getCount()).withBucketCount(dp.getBucketCountsCount()).withExplicitBoundsCount(dp.getExplicitBoundsCount()).withAggregationTemporality(metric.getHistogram().getAggregationTemporality().toString()).withBucketCountsList(dp.getBucketCountsList()).withExplicitBoundsList(dp.getExplicitBoundsList()).withAttributes(OTelProtoOpensearchCodec.mergeAllAttributes(Arrays.asList(OTelProtoOpensearchCodec.unpackKeyValueListMetric(dp.getAttributesList()), resourceAttributes, ils)))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoOpensearchCodec.convertExemplars(dp.getExemplarsList()))).withTimeReceived(timeReceived).withFlags(Integer.valueOf(dp.getFlags()));
                if (calculateHistogramBuckets) {
                    builder.withBuckets(OTelProtoOpensearchCodec.createBuckets(dp.getBucketCountsList(), dp.getExplicitBoundsList()));
                }
                JacksonHistogram jh = builder.build(flattenAttributes);
                return jh;
            }).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapExponentialHistogram(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Integer exponentialHistogramMaxAllowedScale, Instant timeReceived, boolean calculateExponentialHistogramBuckets, boolean flattenAttributes) {
            return metric.getExponentialHistogram().getDataPointsList().stream().filter(dp -> {
                if (calculateExponentialHistogramBuckets && exponentialHistogramMaxAllowedScale < Math.abs(dp.getScale())) {
                    LOG.error("Exponential histogram can not be processed since its scale of {} is bigger than the configured max of {}.", (Object)dp.getScale(), (Object)exponentialHistogramMaxAllowedScale);
                    return false;
                }
                return true;
            }).map(dp -> {
                JacksonExponentialHistogram.Builder builder = (JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)JacksonExponentialHistogram.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withServiceName(serviceName)).withSum(dp.getSum()).withCount(dp.getCount()).withZeroCount(dp.getZeroCount()).withScale(dp.getScale()).withPositive(dp.getPositive().getBucketCountsList()).withPositiveOffset(dp.getPositive().getOffset()).withNegative(dp.getNegative().getBucketCountsList()).withNegativeOffset(dp.getNegative().getOffset()).withAggregationTemporality(metric.getHistogram().getAggregationTemporality().toString()).withAttributes(OTelProtoOpensearchCodec.mergeAllAttributes(Arrays.asList(OTelProtoOpensearchCodec.unpackKeyValueListMetric(dp.getAttributesList()), resourceAttributes, ils)))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoOpensearchCodec.convertExemplars(dp.getExemplarsList()))).withTimeReceived(timeReceived).withFlags(Integer.valueOf(dp.getFlags()));
                if (calculateExponentialHistogramBuckets) {
                    builder.withPositiveBuckets(OTelProtoOpensearchCodec.createExponentialBuckets(dp.getPositive(), dp.getScale()));
                    builder.withNegativeBuckets(OTelProtoOpensearchCodec.createExponentialBuckets(dp.getNegative(), dp.getScale()));
                }
                return builder.build(flattenAttributes);
            }).map(Record::new).collect(Collectors.toList());
        }
    }

    static class BoundsKey {
        private final Integer scale;
        private final Sign sign;

        public BoundsKey(Integer scale, Sign sign) {
            this.scale = scale;
            this.sign = sign;
        }

        public Integer getScale() {
            return this.scale;
        }

        public Sign getSign() {
            return this.sign;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundsKey boundsKey = (BoundsKey)o;
            return this.scale.equals(boundsKey.scale) && this.sign == boundsKey.sign;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scale, this.sign});
        }

        public static enum Sign {
            POSITIVE,
            NEGATIVE;

        }
    }
}

