/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import com.google.protobuf.ByteString;
import java.time.Instant;
import org.apache.commons.codec.binary.Hex;

public class OTelProtoCommonUtils {
    public static final long NANO_MULTIPLIER = 1000000000L;

    public static String convertUnixNanosToISO8601(long unixNano) {
        return Instant.ofEpochSecond(0L, unixNano).toString();
    }

    public static long convertISO8601ToNanos(String timeISO08601) {
        Instant instant = Instant.parse(timeISO08601);
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public static String convertByteStringToString(ByteString bs) {
        return Hex.encodeHexString((byte[])bs.toByteArray());
    }
}

