/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Mapper {
    private static final String LOG_GROUP = "com.apptasticsoftware.rssreader.util";

    private Mapper() {
    }

    public static void mapBoolean(String text, Consumer<Boolean> func) {
        if ("true".equals(text = text.toLowerCase()) || "yes".equals(text)) {
            func.accept(Boolean.TRUE);
        } else if ("false".equals(text) || "no".equals(text)) {
            func.accept(Boolean.FALSE);
        }
    }

    public static void mapInteger(String text, Consumer<Integer> func) {
        Mapper.mapNumber(text, func, Integer::valueOf);
    }

    public static void mapLong(String text, Consumer<Long> func) {
        Mapper.mapNumber(text, func, Long::valueOf);
    }

    private static <T> void mapNumber(String text, Consumer<T> func, Function<String, T> convert) {
        block3: {
            if (text != null && !text.isBlank()) {
                try {
                    func.accept(convert.apply(text));
                }
                catch (NumberFormatException e) {
                    Logger logger = Logger.getLogger(LOG_GROUP);
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.log(Level.WARNING, () -> String.format("Failed to convert %s. Message: %s", text, e.getMessage()));
                }
            }
        }
    }

    public static <T> void mapIfEmpty(String text, Supplier<T> getter, Consumer<String> setter) {
        if (!(getter.get() != null && getter.get() != Optional.empty() || text == null || text.isBlank())) {
            setter.accept(text);
        }
    }

    public static <T> T createIfNull(Supplier<Optional<T>> getter, Consumer<T> setter, Supplier<T> factory) {
        return Mapper.createIfNullOptional(getter, setter, factory).orElse(null);
    }

    public static <T> Optional<T> createIfNullOptional(Supplier<Optional<T>> getter, Consumer<T> setter, Supplier<T> factory) {
        Optional<T> instance = getter.get();
        if (instance.isEmpty()) {
            T newInstance = factory.get();
            setter.accept(newInstance);
            instance = Optional.of(newInstance);
        }
        return instance;
    }
}

