/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTime;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Enclosure;
import com.apptasticsoftware.rssreader.Image;
import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.util.Mapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractRssReader<C extends Channel, I extends Item> {
    private static final String LOG_GROUP = "com.apptasticsoftware.rssreader";
    private final HttpClient httpClient;
    private DateTimeParser dateTimeParser = new DateTime();
    private String userAgent = "";
    private final Map<String, String> headers = new HashMap<String, String>();
    private final HashMap<String, BiConsumer<C, String>> channelTags = new HashMap();
    private final HashMap<String, Map<String, BiConsumer<C, String>>> channelAttributes = new HashMap();
    private final HashMap<String, Consumer<I>> onItemTags = new HashMap();
    private final HashMap<String, BiConsumer<I, String>> itemTags = new HashMap();
    private final HashMap<String, Map<String, BiConsumer<I, String>>> itemAttributes = new HashMap();
    private final Set<String> collectChildNodesForTag = Set.of("content", "summary");
    private boolean isInitialized;

    protected AbstractRssReader() {
        this.httpClient = this.createHttpClient();
    }

    protected AbstractRssReader(HttpClient httpClient) {
        Objects.requireNonNull(httpClient, "Http client must not be null");
        this.httpClient = httpClient;
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    protected C createChannel() {
        return null;
    }

    protected abstract C createChannel(DateTimeParser var1);

    @Deprecated(since="3.5.0", forRemoval=true)
    protected I createItem() {
        return null;
    }

    protected abstract I createItem(DateTimeParser var1);

    protected void initialize() {
        this.registerChannelTags();
        this.registerChannelAttributes();
        this.registerItemTags();
        this.registerItemAttributes();
    }

    protected void registerChannelTags() {
        this.channelTags.putIfAbsent("title", Channel::setTitle);
        this.channelTags.putIfAbsent("description", Channel::setDescription);
        this.channelTags.putIfAbsent("subtitle", Channel::setDescription);
        this.channelTags.putIfAbsent("link", Channel::setLink);
        this.channelTags.putIfAbsent("category", Channel::addCategory);
        this.channelTags.putIfAbsent("language", Channel::setLanguage);
        this.channelTags.putIfAbsent("copyright", Channel::setCopyright);
        this.channelTags.putIfAbsent("rights", Channel::setCopyright);
        this.channelTags.putIfAbsent("generator", Channel::setGenerator);
        this.channelTags.putIfAbsent("ttl", Channel::setTtl);
        this.channelTags.putIfAbsent("pubDate", Channel::setPubDate);
        this.channelTags.putIfAbsent("lastBuildDate", Channel::setLastBuildDate);
        this.channelTags.putIfAbsent("updated", Channel::setLastBuildDate);
        this.channelTags.putIfAbsent("managingEditor", Channel::setManagingEditor);
        this.channelTags.putIfAbsent("webMaster", Channel::setWebMaster);
        this.channelTags.putIfAbsent("docs", Channel::setDocs);
        this.channelTags.putIfAbsent("rating", Channel::setRating);
        this.channelTags.putIfAbsent("/rss/channel/image/link", (c, v) -> Mapper.createIfNull(c::getImage, c::setImage, Image::new).setLink((String)v));
        this.channelTags.putIfAbsent("/rss/channel/image/title", (c, v) -> Mapper.createIfNull(c::getImage, c::setImage, Image::new).setTitle((String)v));
        this.channelTags.putIfAbsent("/rss/channel/image/url", (c, v) -> Mapper.createIfNull(c::getImage, c::setImage, Image::new).setUrl((String)v));
        this.channelTags.putIfAbsent("/rss/channel/image/description", (c, v) -> Mapper.createIfNullOptional(c::getImage, c::setImage, Image::new).ifPresent(i -> i.setDescription((String)v)));
        this.channelTags.putIfAbsent("/rss/channel/image/height", (c, v) -> Mapper.createIfNullOptional(c::getImage, c::setImage, Image::new).ifPresent(i -> Mapper.mapInteger(v, i::setHeight)));
        this.channelTags.putIfAbsent("/rss/channel/image/width", (c, v) -> Mapper.createIfNullOptional(c::getImage, c::setImage, Image::new).ifPresent(i -> Mapper.mapInteger(v, i::setWidth)));
    }

    protected void registerChannelAttributes() {
        this.channelAttributes.computeIfAbsent("link", k -> new HashMap()).put("href", Channel::setLink);
    }

    protected void registerItemTags() {
        this.itemTags.putIfAbsent("guid", Item::setGuid);
        this.itemTags.putIfAbsent("id", Item::setGuid);
        this.itemTags.putIfAbsent("title", Item::setTitle);
        this.itemTags.putIfAbsent("description", Item::setDescription);
        this.itemTags.putIfAbsent("summary", Item::setDescription);
        this.itemTags.putIfAbsent("content", Item::setDescription);
        this.itemTags.putIfAbsent("link", Item::setLink);
        this.itemTags.putIfAbsent("author", Item::setAuthor);
        this.itemTags.putIfAbsent("/feed/entry/author/name", Item::setAuthor);
        this.itemTags.putIfAbsent("category", Item::addCategory);
        this.itemTags.putIfAbsent("pubDate", Item::setPubDate);
        this.itemTags.putIfAbsent("published", Item::setPubDate);
        this.itemTags.putIfAbsent("updated", (i, v) -> {
            if (i.getPubDate().isEmpty()) {
                i.setPubDate((String)v);
            }
        });
        this.itemTags.putIfAbsent("comments", Item::setComments);
        this.itemTags.putIfAbsent("dc:creator", (i, v) -> Mapper.mapIfEmpty(v, i::getAuthor, i::setAuthor));
        this.itemTags.putIfAbsent("dc:date", (i, v) -> Mapper.mapIfEmpty(v, i::getPubDate, i::setPubDate));
        this.onItemTags.put("enclosure", i -> i.addEnclosure(new Enclosure()));
    }

    protected void registerItemAttributes() {
        this.itemAttributes.computeIfAbsent("link", k -> new HashMap()).putIfAbsent("href", Item::setLink);
        this.itemAttributes.computeIfAbsent("guid", k -> new HashMap()).putIfAbsent("isPermaLink", (i, v) -> i.setIsPermaLink(Boolean.parseBoolean(v)));
        Map enclosureAttributes = this.itemAttributes.computeIfAbsent("enclosure", k -> new HashMap());
        enclosureAttributes.putIfAbsent("url", (i, v) -> i.getEnclosure().ifPresent(a -> a.setUrl((String)v)));
        enclosureAttributes.putIfAbsent("type", (i, v) -> i.getEnclosure().ifPresent(a -> a.setType((String)v)));
        enclosureAttributes.putIfAbsent("length", (i, v) -> i.getEnclosure().ifPresent(e -> Mapper.mapLong(v, e::setLength)));
    }

    public AbstractRssReader<C, I> setDateTimeParser(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, "Date time parser must not be null");
        this.dateTimeParser = dateTimeParser;
        return this;
    }

    public AbstractRssReader<C, I> setUserAgent(String userAgent) {
        Objects.requireNonNull(userAgent, "User-agent must not be null");
        this.userAgent = userAgent;
        return this;
    }

    public AbstractRssReader<C, I> addHeader(String key, String value) {
        Objects.requireNonNull(key, "Key must not be null");
        Objects.requireNonNull(value, "Value must not be null");
        this.headers.put(key, value);
        return this;
    }

    public AbstractRssReader<C, I> addItemExtension(String tag, BiConsumer<I, String> consumer) {
        Objects.requireNonNull(tag, "Item tag must not be null");
        Objects.requireNonNull(consumer, "Item consumer must not be null");
        this.itemTags.put(tag, consumer);
        return this;
    }

    public AbstractRssReader<C, I> addItemExtension(String tag, String attribute, BiConsumer<I, String> consumer) {
        Objects.requireNonNull(tag, "Item tag must not be null");
        Objects.requireNonNull(attribute, "Item attribute must not be null");
        Objects.requireNonNull(consumer, "Item consumer must not be null");
        this.itemAttributes.computeIfAbsent(tag, k -> new HashMap()).put(attribute, consumer);
        return this;
    }

    public AbstractRssReader<C, I> addChannelExtension(String tag, BiConsumer<C, String> consumer) {
        Objects.requireNonNull(tag, "Channel tag must not be null");
        Objects.requireNonNull(consumer, "Channel consumer must not be null");
        this.channelTags.put(tag, consumer);
        return this;
    }

    public AbstractRssReader<C, I> addChannelExtension(String tag, String attribute, BiConsumer<C, String> consumer) {
        Objects.requireNonNull(tag, "Channel tag must not be null");
        Objects.requireNonNull(attribute, "Channel attribute must not be null");
        Objects.requireNonNull(consumer, "Channel consumer must not be null");
        this.channelAttributes.computeIfAbsent(tag, k -> new HashMap()).put(attribute, consumer);
        return this;
    }

    public Stream<I> read(String url) throws IOException {
        Objects.requireNonNull(url, "URL must not be null");
        try {
            return this.readAsync(url).get(1L, TimeUnit.MINUTES);
        }
        catch (CompletionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                throw new AssertionError((Object)e2);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public Stream<Item> read(Collection<String> urls) {
        Objects.requireNonNull(urls, "URLs collection must not be null");
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        return ((Stream)urls.stream().parallel()).map(url -> {
            try {
                return Map.entry(url, this.readAsync((String)url));
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(LOG_GROUP);
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, () -> String.format("Failed read URL %s. Message: %s", url, e.getMessage()));
                }
                return null;
            }
        }).filter(Objects::nonNull).flatMap(f -> {
            try {
                return (Stream)((CompletableFuture)f.getValue()).join();
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(LOG_GROUP);
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, () -> String.format("Failed to read URL %s. Message: %s", f.getKey(), e.getMessage()));
                }
                return null;
            }
        });
    }

    public Stream<I> read(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Input stream must not be null");
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        RssItemIterator itemIterator = new RssItemIterator(inputStream);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(itemIterator, 16), false).onClose(itemIterator::close);
    }

    public CompletableFuture<Stream<I>> readAsync(String url) {
        Objects.requireNonNull(url, "URL must not be null");
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        return this.sendAsyncRequest(url).thenApply(this.processResponse());
    }

    protected CompletableFuture<HttpResponse<InputStream>> sendAsyncRequest(String url) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(25L)).header("Accept-Encoding", "gzip");
        if (!this.userAgent.isBlank()) {
            builder.header("User-Agent", this.userAgent);
        }
        this.headers.forEach(builder::header);
        return this.httpClient.sendAsync(builder.GET().build(), HttpResponse.BodyHandlers.ofInputStream());
    }

    private Function<HttpResponse<InputStream>, Stream<I>> processResponse() {
        return response -> {
            try {
                if (response.statusCode() >= 400 && response.statusCode() < 600) {
                    throw new IOException("Response http status code: " + response.statusCode());
                }
                InputStream inputStream = (InputStream)response.body();
                if (Optional.of("gzip").equals(response.headers().firstValue("Content-Encoding"))) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                inputStream = new BufferedInputStream(inputStream);
                this.removeBadData(inputStream);
                RssItemIterator itemIterator = new RssItemIterator(inputStream);
                return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(itemIterator, 16), false).onClose(itemIterator::close);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        };
    }

    private void removeBadData(InputStream inputStream) throws IOException {
        int secondChar;
        inputStream.mark(2);
        int firstChar = inputStream.read();
        if (firstChar != 65279 && firstChar != 13 && firstChar != 10 && !Character.isWhitespace(firstChar)) {
            inputStream.reset();
        } else if ((firstChar == 13 || Character.isWhitespace(firstChar)) && (secondChar = inputStream.read()) != 10 && !Character.isWhitespace(secondChar)) {
            inputStream.reset();
            inputStream.read();
        }
    }

    private HttpClient createHttpClient() {
        HttpClient client;
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.3");
            context.init(null, null, null);
            client = HttpClient.newBuilder().sslContext(context).connectTimeout(Duration.ofSeconds(25L)).followRedirects(HttpClient.Redirect.ALWAYS).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(25L)).followRedirects(HttpClient.Redirect.ALWAYS).build();
        }
        return client;
    }

    class RssItemIterator
    implements Iterator<I> {
        private final StringBuilder textBuilder;
        private final Map<String, StringBuilder> childNodeTextBuilder;
        private final InputStream is;
        private final Deque<String> elementStack;
        private XMLStreamReader reader;
        private C channel;
        private I item;
        private I nextItem;
        private boolean isChannelPart;
        private boolean isItemPart;

        public RssItemIterator(InputStream is) {
            block2: {
                this.item = null;
                this.isChannelPart = false;
                this.isItemPart = false;
                this.is = is;
                this.nextItem = null;
                this.textBuilder = new StringBuilder();
                this.childNodeTextBuilder = new HashMap<String, StringBuilder>();
                this.elementStack = new ArrayDeque<String>();
                try {
                    XMLInputFactory xmlInFact = XMLInputFactory.newInstance();
                    xmlInFact.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                    xmlInFact.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                    xmlInFact.setProperty("javax.xml.stream.isCoalescing", true);
                    this.reader = xmlInFact.createXMLStreamReader(is);
                }
                catch (XMLStreamException e) {
                    Logger logger = Logger.getLogger(AbstractRssReader.LOG_GROUP);
                    if (!logger.isLoggable(Level.WARNING)) break block2;
                    logger.log(Level.WARNING, "Failed to process XML. ", e);
                }
            }
        }

        public void close() {
            block2: {
                try {
                    this.reader.close();
                    this.is.close();
                }
                catch (IOException | XMLStreamException e) {
                    Logger logger = Logger.getLogger(AbstractRssReader.LOG_GROUP);
                    if (!logger.isLoggable(Level.WARNING)) break block2;
                    logger.log(Level.WARNING, "Failed to close XML stream. ", e);
                }
            }
        }

        void peekNext() {
            if (this.nextItem == null) {
                try {
                    this.nextItem = this.next();
                }
                catch (NoSuchElementException e) {
                    this.nextItem = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.peekNext();
            return this.nextItem != null;
        }

        @Override
        public I next() {
            block6: {
                if (this.nextItem != null) {
                    Object next = this.nextItem;
                    this.nextItem = null;
                    return next;
                }
                try {
                    while (this.reader.hasNext()) {
                        boolean itemParsed;
                        int type = this.reader.next();
                        this.collectChildNodes(type);
                        if (type == 4 || type == 12) {
                            this.parseCharacters();
                            continue;
                        }
                        if (type == 1) {
                            this.parseStartElement();
                            this.parseAttributes();
                            continue;
                        }
                        if (type != 2 || !(itemParsed = this.parseEndElement())) continue;
                        return this.item;
                    }
                }
                catch (XMLStreamException e) {
                    Logger logger = Logger.getLogger(AbstractRssReader.LOG_GROUP);
                    if (!logger.isLoggable(Level.WARNING)) break block6;
                    logger.log(Level.WARNING, "Failed to parse XML. ", e);
                }
            }
            this.close();
            throw new NoSuchElementException();
        }

        void collectChildNodes(int type) {
            if (type == 1) {
                String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
                if (!this.childNodeTextBuilder.isEmpty()) {
                    int i;
                    StringBuilder startTagBuilder = new StringBuilder("<").append(nsTagName);
                    for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                        startTagBuilder.append(" ").append(this.toNamespacePrefix(this.reader.getNamespacePrefix(i))).append("=").append(this.reader.getNamespaceURI(i));
                    }
                    for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                        startTagBuilder.append(" ").append(this.toNsName(this.reader.getAttributePrefix(i), this.reader.getAttributeLocalName(i))).append("=").append(this.reader.getAttributeValue(i));
                    }
                    startTagBuilder.append(">");
                    String startTag = startTagBuilder.toString();
                    this.childNodeTextBuilder.entrySet().stream().filter(e -> !((String)e.getKey()).equals(nsTagName)).forEach(e -> ((StringBuilder)e.getValue()).append(startTag));
                }
                if (AbstractRssReader.this.collectChildNodesForTag.contains(nsTagName)) {
                    this.childNodeTextBuilder.put(nsTagName, new StringBuilder());
                }
            } else if (type == 4 || type == 12) {
                this.childNodeTextBuilder.forEach((k, builder) -> builder.append(this.reader.getText()));
            } else if (type == 2) {
                String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
                String endTag = "</" + nsTagName + ">";
                this.childNodeTextBuilder.entrySet().stream().filter(e -> !((String)e.getKey()).equals(nsTagName)).forEach(e -> ((StringBuilder)e.getValue()).append(endTag));
            }
        }

        void parseStartElement() {
            this.textBuilder.setLength(0);
            String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
            this.elementStack.addLast(nsTagName);
            if (this.isChannel(nsTagName)) {
                this.channel = (Channel)Objects.requireNonNullElse(AbstractRssReader.this.createChannel(AbstractRssReader.this.dateTimeParser), AbstractRssReader.this.createChannel());
                ((Channel)this.channel).setTitle("");
                ((Channel)this.channel).setDescription("");
                ((Channel)this.channel).setLink("");
                this.isChannelPart = true;
            } else if (this.isItem(nsTagName)) {
                this.item = (Item)Objects.requireNonNullElse(AbstractRssReader.this.createItem(AbstractRssReader.this.dateTimeParser), AbstractRssReader.this.createItem());
                ((Item)this.item).setChannel((Channel)this.channel);
                this.isChannelPart = false;
                this.isItemPart = true;
            }
        }

        protected boolean isChannel(String tagName) {
            return "channel".equals(tagName) || "feed".equals(tagName);
        }

        protected boolean isItem(String tagName) {
            return "item".equals(tagName) || "entry".equals(tagName);
        }

        void parseAttributes() {
            String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
            String elementFullPath = this.getElementFullPath();
            if (this.isChannelPart) {
                this.mapChannelAttributes(nsTagName);
                this.mapChannelAttributes(elementFullPath);
            } else if (this.isItemPart) {
                AbstractRssReader.this.onItemTags.computeIfPresent(nsTagName, (k, f) -> {
                    f.accept(this.item);
                    return f;
                });
                AbstractRssReader.this.onItemTags.computeIfPresent(this.getElementFullPath(), (k, f) -> {
                    f.accept(this.item);
                    return f;
                });
                this.mapItemAttributes(nsTagName);
                this.mapItemAttributes(elementFullPath);
            }
        }

        void mapChannelAttributes(String key) {
            Map consumers = AbstractRssReader.this.channelAttributes.get(key);
            if (consumers != null && this.channel != null) {
                consumers.forEach((attributeName, consumer) -> {
                    Optional<String> attributeValue = Optional.ofNullable(this.reader.getAttributeValue(null, (String)attributeName));
                    attributeValue.ifPresent(v -> consumer.accept(this.channel, v));
                });
            }
        }

        void mapItemAttributes(String key) {
            Map consumers = AbstractRssReader.this.itemAttributes.get(key);
            if (consumers != null && this.item != null) {
                consumers.forEach((attributeName, consumer) -> {
                    Optional<String> attributeValue = Optional.ofNullable(this.reader.getAttributeValue(null, (String)attributeName));
                    attributeValue.ifPresent(v -> consumer.accept(this.item, v));
                });
            }
        }

        boolean parseEndElement() {
            String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
            String text = this.textBuilder.toString().trim();
            String elementFullPath = this.getElementFullPath();
            this.elementStack.removeLast();
            if (this.isChannelPart) {
                this.parseChannelCharacters(this.channel, nsTagName, elementFullPath, text);
            } else {
                this.parseItemCharacters(this.item, nsTagName, elementFullPath, text);
            }
            this.textBuilder.setLength(0);
            return this.isItem(nsTagName);
        }

        void parseCharacters() {
            String text = this.reader.getText();
            if (text.isBlank()) {
                return;
            }
            this.textBuilder.append(text);
        }

        void parseChannelCharacters(C channel, String nsTagName, String elementFullPath, String text) {
            if (channel == null || text.isEmpty()) {
                return;
            }
            AbstractRssReader.this.channelTags.computeIfPresent(nsTagName, (k, f) -> {
                f.accept(channel, text);
                return f;
            });
            AbstractRssReader.this.channelTags.computeIfPresent(elementFullPath, (k, f) -> {
                f.accept(channel, text);
                return f;
            });
        }

        void parseItemCharacters(I item, String nsTagName, String elementFullPath, String text) {
            StringBuilder builder = this.childNodeTextBuilder.remove(nsTagName);
            if (item == null || text.isEmpty() && builder == null) {
                return;
            }
            String textValue = builder != null ? builder.toString().trim() : text;
            AbstractRssReader.this.itemTags.computeIfPresent(nsTagName, (k, f) -> {
                f.accept(item, textValue);
                return f;
            });
            AbstractRssReader.this.itemTags.computeIfPresent(elementFullPath, (k, f) -> {
                f.accept(item, text);
                return f;
            });
        }

        String toNsName(String prefix, String name) {
            return prefix.isEmpty() ? name : prefix + ":" + name;
        }

        String toNamespacePrefix(String prefix) {
            return prefix == null || prefix.isEmpty() ? "xmlns" : "xmlns:" + prefix;
        }

        String getElementFullPath() {
            return "/" + String.join((CharSequence)"/", this.elementStack);
        }
    }
}

