/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.WorkforceIntegration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.WorkforceIntegrationCollectionPage;
import com.microsoft.graph.requests.WorkforceIntegrationCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkforceIntegrationCollectionResponse;
import com.microsoft.graph.requests.WorkforceIntegrationRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkforceIntegrationCollectionRequest
extends BaseEntityCollectionRequest<WorkforceIntegration, WorkforceIntegrationCollectionResponse, WorkforceIntegrationCollectionPage> {
    public WorkforceIntegrationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkforceIntegrationCollectionResponse.class, WorkforceIntegrationCollectionPage.class, WorkforceIntegrationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<WorkforceIntegration> postAsync(@Nonnull WorkforceIntegration newWorkforceIntegration) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkforceIntegrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newWorkforceIntegration);
    }

    @Nonnull
    public WorkforceIntegration post(@Nonnull WorkforceIntegration newWorkforceIntegration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkforceIntegrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkforceIntegration);
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public WorkforceIntegrationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

