/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.DirectoryObjectCheckMemberGroupsParameterSet;
import com.microsoft.graph.models.DirectoryObjectCheckMemberObjectsParameterSet;
import com.microsoft.graph.models.DirectoryObjectGetMemberGroupsParameterSet;
import com.microsoft.graph.models.DirectoryObjectGetMemberObjectsParameterSet;
import com.microsoft.graph.models.Organization;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.CertificateBasedAuthConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.CertificateBasedAuthConfigurationRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectCheckMemberGroupsCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectCheckMemberObjectsCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectGetMemberGroupsCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectGetMemberObjectsCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectRestoreRequestBuilder;
import com.microsoft.graph.requests.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.ExtensionRequestBuilder;
import com.microsoft.graph.requests.OrganizationRequest;
import com.microsoft.graph.requests.OrganizationSetMobileDeviceManagementAuthorityRequestBuilder;
import com.microsoft.graph.requests.OrganizationalBrandingRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrganizationRequestBuilder
extends BaseRequestBuilder<Organization> {
    public OrganizationRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public OrganizationRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public OrganizationRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new OrganizationRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public OrganizationalBrandingRequestBuilder branding() {
        return new OrganizationalBrandingRequestBuilder(this.getRequestUrlWithAdditionalSegment("branding"), this.getClient(), null);
    }

    @Nonnull
    public CertificateBasedAuthConfigurationCollectionRequestBuilder certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfigurationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("certificateBasedAuthConfiguration"), this.getClient(), null);
    }

    @Nonnull
    public CertificateBasedAuthConfigurationRequestBuilder certificateBasedAuthConfiguration(@Nonnull String id) {
        return new CertificateBasedAuthConfigurationRequestBuilder(this.getRequestUrlWithAdditionalSegment("certificateBasedAuthConfiguration") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ExtensionCollectionRequestBuilder extensions() {
        return new ExtensionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("extensions"), this.getClient(), null);
    }

    @Nonnull
    public ExtensionRequestBuilder extensions(@Nonnull String id) {
        return new ExtensionRequestBuilder(this.getRequestUrlWithAdditionalSegment("extensions") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public OrganizationSetMobileDeviceManagementAuthorityRequestBuilder setMobileDeviceManagementAuthority() {
        return new OrganizationSetMobileDeviceManagementAuthorityRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.setMobileDeviceManagementAuthority"), this.getClient(), null);
    }

    @Nonnull
    public DirectoryObjectCheckMemberGroupsCollectionRequestBuilder checkMemberGroups(@Nonnull DirectoryObjectCheckMemberGroupsParameterSet parameters) {
        return new DirectoryObjectCheckMemberGroupsCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.checkMemberGroups"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DirectoryObjectCheckMemberObjectsCollectionRequestBuilder checkMemberObjects(@Nonnull DirectoryObjectCheckMemberObjectsParameterSet parameters) {
        return new DirectoryObjectCheckMemberObjectsCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.checkMemberObjects"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DirectoryObjectGetMemberGroupsCollectionRequestBuilder getMemberGroups(@Nonnull DirectoryObjectGetMemberGroupsParameterSet parameters) {
        return new DirectoryObjectGetMemberGroupsCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.getMemberGroups"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DirectoryObjectGetMemberObjectsCollectionRequestBuilder getMemberObjects(@Nonnull DirectoryObjectGetMemberObjectsParameterSet parameters) {
        return new DirectoryObjectGetMemberObjectsCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.getMemberObjects"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DirectoryObjectRestoreRequestBuilder restore() {
        return new DirectoryObjectRestoreRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.restore"), this.getClient(), null);
    }
}

