/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.oteltrace.certificate;

import java.time.Duration;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.acm.ACMCertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.file.FileCertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.s3.S3CertificateProvider;
import org.opensearch.dataprepper.plugins.metricpublisher.MicrometerMetricPublisher;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.AcmClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class CertificateProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateProviderFactory.class);
    private static final int ACM_CLIENT_RETRIES = 10;
    private static final long ACM_CLIENT_BASE_BACKOFF_MILLIS = 1000L;
    private static final long ACM_CLIENT_MAX_BACKOFF_MILLIS = 60000L;
    final OTelTraceSourceConfig oTelTraceSourceConfig;

    public CertificateProviderFactory(OTelTraceSourceConfig oTelTraceSourceConfig) {
        this.oTelTraceSourceConfig = oTelTraceSourceConfig;
    }

    public CertificateProvider getCertificateProvider() {
        if (this.oTelTraceSourceConfig.useAcmCertForSSL()) {
            LOG.info("Using ACM certificate and private key for SSL/TLS.");
            AwsCredentialsProviderChain credentialsProvider = AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
            EqualJitterBackoffStrategy backoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(1000L)).maxBackoffTime(Duration.ofMillis(60000L)).build();
            RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(10)).retryCondition(RetryCondition.defaultRetryCondition()).backoffStrategy((BackoffStrategy)backoffStrategy).throttlingBackoffStrategy((BackoffStrategy)backoffStrategy).build();
            ClientOverrideConfiguration clientConfig = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
            PluginMetrics awsSdkMetrics = PluginMetrics.fromNames((String)"sdk", (String)"aws");
            AcmClient awsCertificateManager = (AcmClient)((AcmClientBuilder)((AcmClientBuilder)((AcmClientBuilder)((AcmClientBuilder)AcmClient.builder().region(Region.of((String)this.oTelTraceSourceConfig.getAwsRegion()))).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).overrideConfiguration(clientConfig)).overrideConfiguration(metricPublisher -> metricPublisher.addMetricPublisher((MetricPublisher)new MicrometerMetricPublisher(awsSdkMetrics)))).build();
            return new ACMCertificateProvider(awsCertificateManager, this.oTelTraceSourceConfig.getAcmCertificateArn(), this.oTelTraceSourceConfig.getAcmCertIssueTimeOutMillis(), this.oTelTraceSourceConfig.getAcmPrivateKeyPassword());
        }
        if (this.oTelTraceSourceConfig.isSslCertAndKeyFileInS3()) {
            LOG.info("Using S3 to fetch certificate and private key for SSL/TLS.");
            AwsCredentialsProviderChain credentialsProvider = AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
            S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)this.oTelTraceSourceConfig.getAwsRegion()))).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).build();
            return new S3CertificateProvider(s3Client, this.oTelTraceSourceConfig.getSslKeyCertChainFile(), this.oTelTraceSourceConfig.getSslKeyFile());
        }
        LOG.info("Using local file system to get certificate and private key for SSL/TLS.");
        return new FileCertificateProvider(this.oTelTraceSourceConfig.getSslKeyCertChainFile(), this.oTelTraceSourceConfig.getSslKeyFile());
    }
}

