/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.elasticsearch.watcher.stats.WatcherNodeStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class WatcherStatsResponse
implements JsonpSerializable {
    private final NodeStatistics nodeStats;
    private final String clusterName;
    private final boolean manuallyStopped;
    private final List<WatcherNodeStats> stats;
    public static final JsonpDeserializer<WatcherStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherStatsResponse::setupWatcherStatsResponseDeserializer);

    private WatcherStatsResponse(Builder builder) {
        this.nodeStats = ApiTypeHelper.requireNonNull(builder.nodeStats, this, "nodeStats");
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.manuallyStopped = ApiTypeHelper.requireNonNull(builder.manuallyStopped, this, "manuallyStopped");
        this.stats = ApiTypeHelper.unmodifiableRequired(builder.stats, (Object)this, "stats");
    }

    public static WatcherStatsResponse of(Function<Builder, ObjectBuilder<WatcherStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean manuallyStopped() {
        return this.manuallyStopped;
    }

    public final List<WatcherNodeStats> stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodeStats.serialize(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("manually_stopped");
        generator.write(this.manuallyStopped);
        if (ApiTypeHelper.isDefined(this.stats)) {
            generator.writeKey("stats");
            generator.writeStartArray();
            for (WatcherNodeStats item0 : this.stats) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupWatcherStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes");
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::manuallyStopped, JsonpDeserializer.booleanDeserializer(), "manually_stopped");
        op.add(Builder::stats, JsonpDeserializer.arrayDeserializer(WatcherNodeStats._DESERIALIZER), "stats");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<WatcherStatsResponse> {
        private NodeStatistics nodeStats;
        private String clusterName;
        private Boolean manuallyStopped;
        private List<WatcherNodeStats> stats;

        public final Builder nodeStats(NodeStatistics value) {
            this.nodeStats = value;
            return this;
        }

        public final Builder nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder manuallyStopped(boolean value) {
            this.manuallyStopped = value;
            return this;
        }

        public final Builder stats(List<WatcherNodeStats> list) {
            this.stats = Builder._listAddAll(this.stats, list);
            return this;
        }

        public final Builder stats(WatcherNodeStats value, WatcherNodeStats ... values) {
            this.stats = Builder._listAdd(this.stats, value, values);
            return this;
        }

        public final Builder stats(Function<WatcherNodeStats.Builder, ObjectBuilder<WatcherNodeStats>> fn) {
            return this.stats(fn.apply(new WatcherNodeStats.Builder()).build(), new WatcherNodeStats[0]);
        }

        @Override
        public WatcherStatsResponse build() {
            this._checkSingleUse();
            return new WatcherStatsResponse(this);
        }
    }
}

