/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.IndicesOptions;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.core.SearchTemplateRequest;
import co.elastic.clients.elasticsearch.watcher.SearchInputRequestBody;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchInputRequestDefinition
implements JsonpSerializable {
    @Nullable
    private final SearchInputRequestBody body;
    private final List<String> indices;
    @Nullable
    private final IndicesOptions indicesOptions;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final SearchTemplateRequest template;
    @Nullable
    private final Boolean restTotalHitsAsInt;
    public static final JsonpDeserializer<SearchInputRequestDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchInputRequestDefinition::setupSearchInputRequestDefinitionDeserializer);

    private SearchInputRequestDefinition(Builder builder) {
        this.body = builder.body;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.indicesOptions = builder.indicesOptions;
        this.searchType = builder.searchType;
        this.template = builder.template;
        this.restTotalHitsAsInt = builder.restTotalHitsAsInt;
    }

    public static SearchInputRequestDefinition of(Function<Builder, ObjectBuilder<SearchInputRequestDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SearchInputRequestBody body() {
        return this.body;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final SearchTemplateRequest template() {
        return this.template;
    }

    @Nullable
    public final Boolean restTotalHitsAsInt() {
        return this.restTotalHitsAsInt;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.body != null) {
            generator.writeKey("body");
            this.body.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        if (this.searchType != null) {
            generator.writeKey("search_type");
            this.searchType.serialize(generator, mapper);
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.restTotalHitsAsInt != null) {
            generator.writeKey("rest_total_hits_as_int");
            generator.write(this.restTotalHitsAsInt.booleanValue());
        }
    }

    protected static void setupSearchInputRequestDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::body, SearchInputRequestBody._DESERIALIZER, "body");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::indicesOptions, IndicesOptions._DESERIALIZER, "indices_options");
        op.add(Builder::searchType, SearchType._DESERIALIZER, "search_type");
        op.add(Builder::template, SearchTemplateRequest._DESERIALIZER, "template");
        op.add(Builder::restTotalHitsAsInt, JsonpDeserializer.booleanDeserializer(), "rest_total_hits_as_int");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SearchInputRequestDefinition> {
        @Nullable
        private SearchInputRequestBody body;
        @Nullable
        private List<String> indices;
        @Nullable
        private IndicesOptions indicesOptions;
        @Nullable
        private SearchType searchType;
        @Nullable
        private SearchTemplateRequest template;
        @Nullable
        private Boolean restTotalHitsAsInt;

        public final Builder body(@Nullable SearchInputRequestBody value) {
            this.body = value;
            return this;
        }

        public final Builder body(Function<SearchInputRequestBody.Builder, ObjectBuilder<SearchInputRequestBody>> fn) {
            return this.body(fn.apply(new SearchInputRequestBody.Builder()).build());
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indicesOptions(@Nullable IndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public final Builder indicesOptions(Function<IndicesOptions.Builder, ObjectBuilder<IndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new IndicesOptions.Builder()).build());
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder template(@Nullable SearchTemplateRequest value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<SearchTemplateRequest.Builder, ObjectBuilder<SearchTemplateRequest>> fn) {
            return this.template(fn.apply(new SearchTemplateRequest.Builder()).build());
        }

        public final Builder restTotalHitsAsInt(@Nullable Boolean value) {
            this.restTotalHitsAsInt = value;
            return this;
        }

        @Override
        public SearchInputRequestDefinition build() {
            this._checkSingleUse();
            return new SearchInputRequestDefinition(this);
        }
    }
}

