/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LoggingResult
implements JsonpSerializable {
    private final String loggedText;
    public static final JsonpDeserializer<LoggingResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LoggingResult::setupLoggingResultDeserializer);

    private LoggingResult(Builder builder) {
        this.loggedText = ApiTypeHelper.requireNonNull(builder.loggedText, this, "loggedText");
    }

    public static LoggingResult of(Function<Builder, ObjectBuilder<LoggingResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String loggedText() {
        return this.loggedText;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("logged_text");
        generator.write(this.loggedText);
    }

    protected static void setupLoggingResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::loggedText, JsonpDeserializer.stringDeserializer(), "logged_text");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<LoggingResult> {
        private String loggedText;

        public final Builder loggedText(String value) {
            this.loggedText = value;
            return this;
        }

        @Override
        public LoggingResult build() {
            this._checkSingleUse();
            return new LoggingResult(this);
        }
    }
}

