/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.reindex.Destination;
import co.elastic.clients.elasticsearch.core.reindex.Source;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.Settings;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.elasticsearch.transform.UpdateTransformResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateTransformRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean deferValidation;
    @Nullable
    private final String description;
    @Nullable
    private final Destination dest;
    @Nullable
    private final Time frequency;
    @Nullable
    private final RetentionPolicy retentionPolicy;
    @Nullable
    private final Settings settings;
    @Nullable
    private final Source source;
    @Nullable
    private final Sync sync;
    @Nullable
    private final Time timeout;
    private final String transformId;
    public static final JsonpDeserializer<UpdateTransformRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateTransformRequest::setupUpdateTransformRequestDeserializer);
    public static final Endpoint<UpdateTransformRequest, UpdateTransformResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateTransformRequest, UpdateTransformResponse>("es/transform.update_transform", request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deferValidation != null) {
            params.put("defer_validation", String.valueOf(request.deferValidation));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateTransformResponse._DESERIALIZER);

    private UpdateTransformRequest(Builder builder) {
        this.deferValidation = builder.deferValidation;
        this.description = builder.description;
        this.dest = builder.dest;
        this.frequency = builder.frequency;
        this.retentionPolicy = builder.retentionPolicy;
        this.settings = builder.settings;
        this.source = builder.source;
        this.sync = builder.sync;
        this.timeout = builder.timeout;
        this.transformId = ApiTypeHelper.requireNonNull(builder.transformId, this, "transformId");
    }

    public static UpdateTransformRequest of(Function<Builder, ObjectBuilder<UpdateTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean deferValidation() {
        return this.deferValidation;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Destination dest() {
        return this.dest;
    }

    @Nullable
    public final Time frequency() {
        return this.frequency;
    }

    @Nullable
    public final RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    @Nullable
    public final Settings settings() {
        return this.settings;
    }

    @Nullable
    public final Source source() {
        return this.source;
    }

    @Nullable
    public final Sync sync() {
        return this.sync;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String transformId() {
        return this.transformId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.dest != null) {
            generator.writeKey("dest");
            this.dest.serialize(generator, mapper);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            this.frequency.serialize(generator, mapper);
        }
        if (this.retentionPolicy != null) {
            generator.writeKey("retention_policy");
            this.retentionPolicy.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
        if (this.sync != null) {
            generator.writeKey("sync");
            this.sync.serialize(generator, mapper);
        }
    }

    protected static void setupUpdateTransformRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, Destination._DESERIALIZER, "dest");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::retentionPolicy, RetentionPolicy._DESERIALIZER, "retention_policy");
        op.add(Builder::settings, Settings._DESERIALIZER, "settings");
        op.add(Builder::source, Source._DESERIALIZER, "source");
        op.add(Builder::sync, Sync._DESERIALIZER, "sync");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<UpdateTransformRequest> {
        @Nullable
        private Boolean deferValidation;
        @Nullable
        private String description;
        @Nullable
        private Destination dest;
        @Nullable
        private Time frequency;
        @Nullable
        private RetentionPolicy retentionPolicy;
        @Nullable
        private Settings settings;
        @Nullable
        private Source source;
        @Nullable
        private Sync sync;
        @Nullable
        private Time timeout;
        private String transformId;

        public final Builder deferValidation(@Nullable Boolean value) {
            this.deferValidation = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(@Nullable Destination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public final Builder frequency(@Nullable Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder retentionPolicy(@Nullable RetentionPolicy value) {
            this.retentionPolicy = value;
            return this;
        }

        public final Builder retentionPolicy(Function<RetentionPolicy.Builder, ObjectBuilder<RetentionPolicy>> fn) {
            return this.retentionPolicy(fn.apply(new RetentionPolicy.Builder()).build());
        }

        public final Builder settings(@Nullable Settings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<Settings.Builder, ObjectBuilder<Settings>> fn) {
            return this.settings(fn.apply(new Settings.Builder()).build());
        }

        public final Builder source(@Nullable Source value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public final Builder sync(@Nullable Sync value) {
            this.sync = value;
            return this;
        }

        public final Builder sync(Function<Sync.Builder, ObjectBuilder<Sync>> fn) {
            return this.sync(fn.apply(new Sync.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        @Override
        public UpdateTransformRequest build() {
            this._checkSingleUse();
            return new UpdateTransformRequest(this);
        }
    }
}

