/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HistogramGrouping
implements JsonpSerializable {
    private final List<String> fields;
    private final long interval;
    public static final JsonpDeserializer<HistogramGrouping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramGrouping::setupHistogramGroupingDeserializer);

    private HistogramGrouping(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
    }

    public static HistogramGrouping of(Function<Builder, ObjectBuilder<HistogramGrouping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final long interval() {
        return this.interval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("interval");
        generator.write(this.interval);
    }

    protected static void setupHistogramGroupingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::interval, JsonpDeserializer.longDeserializer(), "interval");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HistogramGrouping> {
        private List<String> fields;
        private Long interval;

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder interval(long value) {
            this.interval = value;
            return this;
        }

        @Override
        public HistogramGrouping build() {
            this._checkSingleUse();
            return new HistogramGrouping(this);
        }
    }
}

