/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PublishedClusterStates
implements JsonpSerializable {
    @Nullable
    private final Long fullStates;
    @Nullable
    private final Long incompatibleDiffs;
    @Nullable
    private final Long compatibleDiffs;
    public static final JsonpDeserializer<PublishedClusterStates> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PublishedClusterStates::setupPublishedClusterStatesDeserializer);

    private PublishedClusterStates(Builder builder) {
        this.fullStates = builder.fullStates;
        this.incompatibleDiffs = builder.incompatibleDiffs;
        this.compatibleDiffs = builder.compatibleDiffs;
    }

    public static PublishedClusterStates of(Function<Builder, ObjectBuilder<PublishedClusterStates>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long fullStates() {
        return this.fullStates;
    }

    @Nullable
    public final Long incompatibleDiffs() {
        return this.incompatibleDiffs;
    }

    @Nullable
    public final Long compatibleDiffs() {
        return this.compatibleDiffs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fullStates != null) {
            generator.writeKey("full_states");
            generator.write(this.fullStates.longValue());
        }
        if (this.incompatibleDiffs != null) {
            generator.writeKey("incompatible_diffs");
            generator.write(this.incompatibleDiffs.longValue());
        }
        if (this.compatibleDiffs != null) {
            generator.writeKey("compatible_diffs");
            generator.write(this.compatibleDiffs.longValue());
        }
    }

    protected static void setupPublishedClusterStatesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fullStates, JsonpDeserializer.longDeserializer(), "full_states");
        op.add(Builder::incompatibleDiffs, JsonpDeserializer.longDeserializer(), "incompatible_diffs");
        op.add(Builder::compatibleDiffs, JsonpDeserializer.longDeserializer(), "compatible_diffs");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PublishedClusterStates> {
        @Nullable
        private Long fullStates;
        @Nullable
        private Long incompatibleDiffs;
        @Nullable
        private Long compatibleDiffs;

        public final Builder fullStates(@Nullable Long value) {
            this.fullStates = value;
            return this;
        }

        public final Builder incompatibleDiffs(@Nullable Long value) {
            this.incompatibleDiffs = value;
            return this;
        }

        public final Builder compatibleDiffs(@Nullable Long value) {
            this.compatibleDiffs = value;
            return this;
        }

        @Override
        public PublishedClusterStates build() {
            this._checkSingleUse();
            return new PublishedClusterStates(this);
        }
    }
}

