/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TotalFeatureImportanceClass;
import co.elastic.clients.elasticsearch.ml.TotalFeatureImportanceStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TotalFeatureImportance
implements JsonpSerializable {
    private final String featureName;
    private final List<TotalFeatureImportanceStatistics> importance;
    private final List<TotalFeatureImportanceClass> classes;
    public static final JsonpDeserializer<TotalFeatureImportance> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TotalFeatureImportance::setupTotalFeatureImportanceDeserializer);

    private TotalFeatureImportance(Builder builder) {
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.importance = ApiTypeHelper.unmodifiableRequired(builder.importance, (Object)this, "importance");
        this.classes = ApiTypeHelper.unmodifiableRequired(builder.classes, (Object)this, "classes");
    }

    public static TotalFeatureImportance of(Function<Builder, ObjectBuilder<TotalFeatureImportance>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String featureName() {
        return this.featureName;
    }

    public final List<TotalFeatureImportanceStatistics> importance() {
        return this.importance;
    }

    public final List<TotalFeatureImportanceClass> classes() {
        return this.classes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        if (ApiTypeHelper.isDefined(this.importance)) {
            generator.writeKey("importance");
            generator.writeStartArray();
            for (TotalFeatureImportanceStatistics totalFeatureImportanceStatistics : this.importance) {
                totalFeatureImportanceStatistics.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.classes)) {
            generator.writeKey("classes");
            generator.writeStartArray();
            for (TotalFeatureImportanceClass totalFeatureImportanceClass : this.classes) {
                totalFeatureImportanceClass.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTotalFeatureImportanceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::importance, JsonpDeserializer.arrayDeserializer(TotalFeatureImportanceStatistics._DESERIALIZER), "importance");
        op.add(Builder::classes, JsonpDeserializer.arrayDeserializer(TotalFeatureImportanceClass._DESERIALIZER), "classes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TotalFeatureImportance> {
        private String featureName;
        private List<TotalFeatureImportanceStatistics> importance;
        private List<TotalFeatureImportanceClass> classes;

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder importance(List<TotalFeatureImportanceStatistics> list) {
            this.importance = Builder._listAddAll(this.importance, list);
            return this;
        }

        public final Builder importance(TotalFeatureImportanceStatistics value, TotalFeatureImportanceStatistics ... values) {
            this.importance = Builder._listAdd(this.importance, value, values);
            return this;
        }

        public final Builder importance(Function<TotalFeatureImportanceStatistics.Builder, ObjectBuilder<TotalFeatureImportanceStatistics>> fn) {
            return this.importance(fn.apply(new TotalFeatureImportanceStatistics.Builder()).build(), new TotalFeatureImportanceStatistics[0]);
        }

        public final Builder classes(List<TotalFeatureImportanceClass> list) {
            this.classes = Builder._listAddAll(this.classes, list);
            return this;
        }

        public final Builder classes(TotalFeatureImportanceClass value, TotalFeatureImportanceClass ... values) {
            this.classes = Builder._listAdd(this.classes, value, values);
            return this;
        }

        public final Builder classes(Function<TotalFeatureImportanceClass.Builder, ObjectBuilder<TotalFeatureImportanceClass>> fn) {
            return this.classes(fn.apply(new TotalFeatureImportanceClass.Builder()).build(), new TotalFeatureImportanceClass[0]);
        }

        @Override
        public TotalFeatureImportance build() {
            this._checkSingleUse();
            return new TotalFeatureImportance(this);
        }
    }
}

