/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewDatafeedResponse<TDocument>
implements JsonpSerializable {
    private final List<TDocument> data;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<PreviewDatafeedResponse<Object>> _DESERIALIZER = PreviewDatafeedResponse.createPreviewDatafeedResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:ml.preview_datafeed.TDocument"));

    private PreviewDatafeedResponse(Builder<TDocument> builder) {
        this.data = ApiTypeHelper.unmodifiableRequired(((Builder)builder).data, (Object)this, "data");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> PreviewDatafeedResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<PreviewDatafeedResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TDocument> data() {
        return this.data;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartArray();
            for (TDocument item0 : this.data) {
                JsonpUtils.serialize(item0, generator, this.tDocumentSerializer, mapper);
            }
            generator.writeEnd();
        }
    }

    public static <TDocument> JsonpDeserializer<PreviewDatafeedResponse<TDocument>> createPreviewDatafeedResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> PreviewDatafeedResponse.setupPreviewDatafeedResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupPreviewDatafeedResponseDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(tDocumentDeserializer), "data");
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<PreviewDatafeedResponse<TDocument>> {
        private List<TDocument> data;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> data(List<TDocument> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        public final Builder<TDocument> data(TDocument value, TDocument ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public PreviewDatafeedResponse<TDocument> build() {
            this._checkSingleUse();
            return new PreviewDatafeedResponse(this);
        }
    }
}

