/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.info.Defaults;
import co.elastic.clients.elasticsearch.ml.info.Limits;
import co.elastic.clients.elasticsearch.ml.info.NativeCode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MlInfoResponse
implements JsonpSerializable {
    private final Defaults defaults;
    private final Limits limits;
    private final boolean upgradeMode;
    private final NativeCode nativeCode;
    public static final JsonpDeserializer<MlInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInfoResponse::setupMlInfoResponseDeserializer);

    private MlInfoResponse(Builder builder) {
        this.defaults = ApiTypeHelper.requireNonNull(builder.defaults, this, "defaults");
        this.limits = ApiTypeHelper.requireNonNull(builder.limits, this, "limits");
        this.upgradeMode = ApiTypeHelper.requireNonNull(builder.upgradeMode, this, "upgradeMode");
        this.nativeCode = ApiTypeHelper.requireNonNull(builder.nativeCode, this, "nativeCode");
    }

    public static MlInfoResponse of(Function<Builder, ObjectBuilder<MlInfoResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Defaults defaults() {
        return this.defaults;
    }

    public final Limits limits() {
        return this.limits;
    }

    public final boolean upgradeMode() {
        return this.upgradeMode;
    }

    public final NativeCode nativeCode() {
        return this.nativeCode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("defaults");
        this.defaults.serialize(generator, mapper);
        generator.writeKey("limits");
        this.limits.serialize(generator, mapper);
        generator.writeKey("upgrade_mode");
        generator.write(this.upgradeMode);
        generator.writeKey("native_code");
        this.nativeCode.serialize(generator, mapper);
    }

    protected static void setupMlInfoResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::defaults, Defaults._DESERIALIZER, "defaults");
        op.add(Builder::limits, Limits._DESERIALIZER, "limits");
        op.add(Builder::upgradeMode, JsonpDeserializer.booleanDeserializer(), "upgrade_mode");
        op.add(Builder::nativeCode, NativeCode._DESERIALIZER, "native_code");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlInfoResponse> {
        private Defaults defaults;
        private Limits limits;
        private Boolean upgradeMode;
        private NativeCode nativeCode;

        public final Builder defaults(Defaults value) {
            this.defaults = value;
            return this;
        }

        public final Builder defaults(Function<Defaults.Builder, ObjectBuilder<Defaults>> fn) {
            return this.defaults(fn.apply(new Defaults.Builder()).build());
        }

        public final Builder limits(Limits value) {
            this.limits = value;
            return this;
        }

        public final Builder limits(Function<Limits.Builder, ObjectBuilder<Limits>> fn) {
            return this.limits(fn.apply(new Limits.Builder()).build());
        }

        public final Builder upgradeMode(boolean value) {
            this.upgradeMode = value;
            return this;
        }

        public final Builder nativeCode(NativeCode value) {
            this.nativeCode = value;
            return this;
        }

        public final Builder nativeCode(Function<NativeCode.Builder, ObjectBuilder<NativeCode>> fn) {
            return this.nativeCode(fn.apply(new NativeCode.Builder()).build());
        }

        @Override
        public MlInfoResponse build() {
            this._checkSingleUse();
            return new MlInfoResponse(this);
        }
    }
}

